# CDI Base

Thème de base pour les sites WordPress CDI.

* Version: 2.1.6
* License: [GPLv2 or later](http://www.gnu.org/licenses/gpl-2.0.html)

## Comment utiliser le thème ?

Ce thème est conçu pour être utilisé comme thème parent.
Il propose les templates et fonctions de base pour créer un nouveau site WordPress léger et personnalisé.

### Installation

Pour installer le thème, il suffit de copier/coller le thème dans le répertoire `wp-content/themes` du site WordPress. Et c'est tout !

Chaque site étant unique, ce thème ne contient aucun style ou composant.

**Ce thème ne doit en aucun cas être modifié pour personnaliser le thème de site. Qu'il s'agisse de styles ou de fonctions, toutes les modifications doivent obligatoirement être faites dans le thème enfant.**

Pour ajouter des modules ou composants, une flotte d'extensions est utilisable pour étendre les fonctionnalités du site.

Plus d'informations sont disponibles dans les fichiers README du modèle de thème enfant CDI Base Child ou des extensions CDI.

### Traductions

Le répertoire `languages` contient les fichiers de traduction du thème.
En cas d'ajout de nouveaux termes dans le thème, il faut mettre à jour ces fichiers avec les traductions dans chacune des langues disponibles.

Pour en savoir plus sur la traduction de thèmes WordPress, voici quelques ressources utiles (en anglais) :
* [Translate WordPress](https://make.wordpress.org/polyglots/teams/)
* [Themes Localization](https://developer.wordpress.org/themes/functionality/localization/)
* [load_theme_textdomain()](https://developer.wordpress.org/reference/functions/load_theme_textdomain/)

## Changelog

L'historique détaillé des modifications est disponible dans le [changelog](http://wp.cdi.ch/themes/cdi-base).

En cas de mise à jour du thème, le fichier `CHANGELOG.md` à mettre à jour se trouve dans le répertoire `depot` du thème de base sur TFS.

La syntaxe du fichier Changelog est la suivante :

```
## 1.0.0 *AAAA-MM-DD*

* **Ajouté :** Nouvelle fonction
* **Modifié :** Changement apporté sur une fonction existante
* **Déprécié :** Fonction dépréciée (généralement supprimée dans une version ultérieure)
* **Supprimé :** Fonction supprimée
* **Corrigé :** Bug fixé
* **Sécurité :** Répare une vulnérabilité, implique en général de faire une mise à jour
```

Pour en savoir plus sur la lecture (et l'édition) d'un changelog, voici deux ressources utiles (en anglais) :
* [Semantic Versioning 2.0.0](http://semver.org/)
* [Keep a Changelog](http://keepachangelog.com/)

## Crédits

* Basé sur [Underscore](http://underscores.me/), (C) 2012-2016 Automattic, Inc., [GPLv2 or later](http://www.gnu.org/licenses/gpl-2.0.html)
