<?php
/**
 * Fichier pour afficher la page d'erreur 404 (page non trouvée)
 *
 * @link    https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
get_header(); ?>

    <div id="site-content" class="site-content">
        <main id="main" class="site-main" role="main">

            <section class="error-404 not-found">
                <header class="page-header">
                    <h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'cdi-base' ); ?></h1>
                </header><!-- .page-header -->

                <div class="page-content">
                    <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'cdi-base' ); ?></p>

                    <?php
                        get_search_form();

                        the_widget( 'WP_Widget_Recent_Posts' );

                        /* On affiche la liste des catégories s'il y en a plusieurs. */
                        if ( cdiwp_categorized_blog() ) :
                    ?>

                    <div class="widget widget_categories">
                        <h2 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'cdi-base' ); ?></h2>
                        <ul>
                        <?php
                            wp_list_categories( array(
                                'orderby'    => 'count',
                                'order'      => 'DESC',
                                'show_count' => 1,
                                'title_li'   => '',
                                'number'     => 10,
                            ) );
                        ?>
                        </ul>
                    </div><!-- .widget -->

                    <?php
                        endif;

                        /* Pour les traducteurs : %1$s: smiley */
                        $archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'cdi-base' ), convert_smilies( ':)' ) ) . '</p>';
                        the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h2>$archive_content" );

                        the_widget( 'WP_Widget_Tag_Cloud' );
                    ?>

                </div><!-- .page-content -->
            </section><!-- .error-404 -->

        </main><!-- #main -->
    </div><!-- #site-content -->

<?php
get_footer();
