<?php
/**
 * Fichier pour afficher la page d'erreur 401 (authentication requise)
 *
 * @link    http://websistent.com/wordpress-custom-403-401-error-page/
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.1
 */
get_header(); ?>

    <div id="site-content" class="site-content">
        <main id="main" class="site-main" role="main">

            <section class="error-401 not-found">
                <header class="page-header">
                    <h1 class="page-title"><?php esc_html_e( 'Oops! You haven&rsquo;t right to see this page.', 'cdi-base' ); ?></h1>
                </header><!-- .page-header -->

                <div class="page-content">
                    <p><?php esc_html_e( 'It looks like you need to be authenticated.', 'cdi-base' ); ?></p>

                    <?php
                        get_search_form();

                        the_widget( 'WP_Widget_Recent_Posts' );

                        /* On affiche la liste des catégories s'il y en a plusieurs. */
                        if ( cdiwp_categorized_blog() ) :
                    ?>

                    <div class="widget widget_categories">
                        <h2 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'cdi-base' ); ?></h2>
                        <ul>
                        <?php
                            wp_list_categories( array(
                                'orderby'    => 'count',
                                'order'      => 'DESC',
                                'show_count' => 1,
                                'title_li'   => '',
                                'number'     => 10,
                            ) );
                        ?>
                        </ul>
                    </div><!-- .widget -->

                    <?php
                        endif;

                        /* Pour les traducteurs : %1$s: smiley */
                        $archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'cdi-base' ), convert_smilies( ':)' ) ) . '</p>';
                        the_widget( 'WP_Widget_Archives', 'dropdown=1', 'after_title=</h2>$archive_content' );

                        the_widget( 'WP_Widget_Tag_Cloud' );
                    ?>

                </div><!-- .page-content -->
            </section><!-- .error-401 -->

        </main><!-- #main -->
    </div><!-- #site-content -->

<?php
get_footer();
