jq2 = jQuery.noConflict();
jq2(function($) {
    // == Sticky Nav Scroll Switch ==
    let updateNavOnScroll = function() {
    let scroll = $(window).scrollTop();
    let nav = $('.site-navigation.centered-logo-nav');

    if (scroll > 50) {
        nav.addClass('scrolled');
        $('body').addClass('nav-highlight-allowed'); // nouvelle classe
    } else {
        nav.removeClass('scrolled');
        $('body').removeClass('nav-highlight-allowed');
    }
};
    updateNavOnScroll();

   // == Smooth Scroll for Anchor Links ==
    $('a[href^="#"]').not('[href="#"]').on('click', function(e) {
        const targetId = $(this).attr('href');
        const $target = $(targetId);

        if ($target.length) {
            e.preventDefault();

            const offset = $(window).width() > 768 ? 100 : 100;
            $('html, body').stop().animate({
                scrollTop: $target.offset().top - offset
            }, 600);
        } else {
            console.warn('No element matches', targetId);
        }
    });

    // == Close mobile menu on link click ==
    $('.mobile-menu a').on('click', function() {
        $('#mobile_navigation').prop('checked', false);
    });

    // == Hero Background Slider with Fade ==
    const hero = $('.site-hero-wrapper');
    const images = [
        '/wp-content/uploads/2025/06/bookshop-header-1.webp',
        '/wp-content/uploads/2025/06/bookshop-header-2.webp',
        '/wp-content/uploads/2025/06/bookshop-header-3.webp',
        '/wp-content/uploads/2025/06/bookshop-header-4.webp'
    ];
    const gradient = 'linear-gradient(to bottom, rgba(22, 13, 1, 0.9), rgba(63, 37, 3, 0.55))';
    const dots = $('.slider-dots .dot');
    const counter = $('.slider-counter');
    let current = 0;

    function updateHeroBackground(index) {
        if (!hero.length) return;

        const newBackground = `${gradient}, url('${images[index]}') no-repeat top center / cover`;

        // Set ::before background via CSS variable for fade effect
        hero.css('--fade-bg', newBackground);
        hero.addClass('fade-transition');

        setTimeout(() => {
            hero.css('background', newBackground);
            hero.removeClass('fade-transition');

            current = index;
            dots.removeClass('active').eq(index).addClass('active');
            if (counter.length) {
                counter.text(`${index + 1} / ${images.length}`);
            }
        }, 800); // Match the CSS fade duration
    }

    // Dot click event
    dots.each(function(i) {
        $(this).on('click', function() {
            if (i !== current) {
                updateHeroBackground(i);
            }
        });
    });

    // Autoplay slider
    setInterval(function() {
        const next = (current + 1) % images.length;
        updateHeroBackground(next);
    }, 6000);

    // Initial background
    updateHeroBackground(current);

    // == Scroll event triggers ==
    $(window).on('scroll', function() {
        updateNavOnScroll();
    });
    
    // == Key feature animation ==
    function animateKeyFeatures() {
    $('.key-feature').each(function(i) {
        const el = $(this);  
        const elementTop = el.offset().top;
        const elementBottom = elementTop + el.outerHeight();
        const windowTop = $(window).scrollTop();
        const windowBottom = windowTop + $(window).height();

        const isVisible = (elementBottom > windowTop) && (elementTop < windowBottom);

        if (isVisible && !el.hasClass('in-view')) {
        setTimeout(() => {
            el.addClass('in-view');
        }, i * 200); 
        }
    });
    }

    $(window).on('scroll resize load', function() {
    animateKeyFeatures();
    });

    // == Scroll Spy: Highlight current nav link ==
    function highlightNavLinksOnScroll() {
        const scrollPos = $(window).scrollTop();
        const offset = 150;

        $('.site-navigation.centered-logo-nav a[href^="#"]').each(function () {
            const href = $(this).attr('href');
            const $target = $(href);
            if ($target.length) {
                const sectionTop = $target.offset().top - offset;
                const sectionBottom = sectionTop + $target.outerHeight();

                if (scrollPos >= sectionTop && scrollPos < sectionBottom) {
                    $(this).addClass('in-section');
                } else {
                    $(this).removeClass('in-section');
                }
            }
        });
    }

    $(window).on('scroll', highlightNavLinksOnScroll);
    highlightNavLinksOnScroll(); // Trigger on page load
});
