<?php
/**
 * Entête de page
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @author  Luc Poupard
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="format-detection" content="telephone=no">
<?php wp_head(); ?>
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/, 'js');</script>

<!-- Google fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400..600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://use.typekit.net/cpt7upx.css">

<!-- Favicon -->
<link rel="apple-touch-icon" sizes="180x180" href="/wp-content/themes/ruffieux/images/favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/wp-content/themes/ruffieux/images/favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/wp-content/themes/ruffieux/images/favicon/favicon-16x16.png">
<link rel="manifest" href="/wp-content/themes/ruffieux/images/favicon/site.webmanifest">
<link rel="mask-icon" href="/wp-content/themes/ruffieux/images/favicon/safari-pinned-tab.svg" color="#5bbad5">
<link rel="shortcut icon" href="/wp-content/themes/ruffieux/images/favicon/favicon.ico">
<meta name="msapplication-TileColor" content="#da532c">
<meta name="msapplication-config" content="/wp-content/themes/ruffieux/images/favicon/browserconfig.xml">
<meta name="theme-color" content="#ffffff">
</head>

<body <?php body_class(); ?> role="document">
<?php
if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}
?>
<div class="site-background"></div>

<div id="site-top">
    <a href="#site-menu" class="screen-reader-text"><span><?php esc_html_e( 'Skip to navigation', 'cdi-base' ); ?></span></a>
    <a href="#site-content" class="screen-reader-text"><span><?php esc_html_e( 'Skip to content', 'cdi-base' ); ?></span></a>
    <a href="#site-search" class="screen-reader-text"><span><?php esc_html_e( 'Skip to search', 'cdi-base' ); ?></span></a>

    <header id="site-header" class="site-header" role="banner">
        <div class="site-header-content site-wrapper">
            <div class="mobile-header">
                <div class="site-header_title mobile-only">
                    <?php if ( is_front_page() ) : ?>
                        <h1>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                                <img src="<?= get_stylesheet_directory_uri(); ?>/images/logo-bookshop.svg" alt="<?= bloginfo( 'name' ); ?>" title="<?= bloginfo( 'name' ); ?>" />
                            </a>
                        </h1>
                    <?php else : ?>
                        <p>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                                <img src="<?= get_stylesheet_directory_uri(); ?>/images/logo-bookshop.svg" alt="<?= bloginfo( 'name' ); ?>" title="<?= bloginfo( 'name' ); ?>" />
                            </a>
                        </p>
                    <?php endif; ?>
                </div>

                <input type="checkbox" id="mobile_navigation" class="hidden" />
                <label for="mobile_navigation" class="menu_mobile">
                    <div id="nav-icon">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </label>

                <!-- toggleable mobile menu -->
                <div class="mobile-menu-wrapper">
                    <div class="mobile-menu-inner">
                        <?php wp_nav_menu( array(
                            'theme_location' => 'primary', // Adjust if you have a dedicated mobile menu
                            'container' => false,
                            'menu_class' => 'mobile-menu'
                        ) ); ?>
                    </div>
                </div>
            </div>

            <nav id="site-navigation" class="site-navigation centered-logo-nav desktop-only" role="navigation">
                <div class="container">
                    <div class="nav-left">
                        <?php wp_nav_menu( array(
                            'theme_location' => 'left-menu',
                            'container' => false,
                            'menu_class' => 'menu left-menu'
                        ) ); ?>
                    </div>

                    <div class="nav-logo">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <img src="<?= get_stylesheet_directory_uri(); ?>/images/logo-bookshop-blanc.svg" alt="<?= bloginfo( 'name' ); ?>" title="<?= bloginfo( 'name' ); ?>" />
                        </a>
                    </div>

                    <div class="nav-right">
                        <?php wp_nav_menu( array(
                            'theme_location' => 'right-menu',
                            'container' => false,
                            'menu_class' => 'menu right-menu'
                        ) ); ?>
                    </div>
                </div>
            </nav><!-- #site-navigation -->
        </div>
    </header><!-- #site-header -->

    <div id="site-content-wrapper">
