<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?> >
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="Système de gestion de librairie en ligne">
  <title>Bookshop : système de gestion de librairie en ligne</title>
  <meta name="format-detection" content="telephone=no">
  <!-- Google Tag Manager -->
  <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
  new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
  j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
  'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
  })(window,document,'script','dataLayer','GTM-NVP4NBM');</script>
  <!-- End Google Tag Manager -->
  <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon.png'; ?>">
  <link rel="icon" type="/img/favicons/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-32x32.png'; ?>" sizes="32x32">
  <link rel="icon" type="/img/favicons/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-16x16.png'; ?>" sizes="16x16">
  <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/css/styles.css">
</head>

<body <?php body_class(); ?> role="document">
  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NVP4NBM"
  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->
  <div class="site-background"></div>

  <div class="site-wrapper">
    <header class="site-header clearfix" role="banner">
      <div class="site-background"></div>
      <div class="site-content">
        <div id="top">
          <nav class="site-navigation site-content" role="navigation">
            <a class="logobook" href="/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/bookshop.svg" width="280" height="163" alt="Accueil"></a>

            <ul id="menu">
              <li><a data-scroll href="/#home">Bookshop</a></li>
              <li><a data-scroll href="/#references">Références</a></li>
              <li><a data-scroll href="/#CDI">Entreprise</a></li>
              <li><a data-scroll href="/tarification">Tarification</a></li>
              <li><a data-scroll href="/#contact">Contact</a></li>
            </ul>
          </nav>
        </div>

        <?php if ( is_front_page() ) : ?>

        <div class="slogan">
          <p>Bookshop, un outil de gestion full web léger, mobile et évolutif pour votre librairie</p>
          <a data-scroll href="#contact" class="button">Je suis intéressé·e</a>
        </div>

      <?php endif; ?>
      </div>
    </header>