<?php
/**
 * Notification de mises à jour du thème
 *
 * @author	Luc Poupard
 *
 * Basé sur le code de Xpark Media :
 * @link	https://xparkmedia.com/blog/add-update-notification-selfhosted-premium-themes-plugins/
 * Mais on utilise wp_remote_get() au lieu de curl_init() :
 * @link	https://pippinsplugins.com/using-wp_remote_get-to-parse-json-from-remote-apis/
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */

function bookshop2018_update_notifier ( $transient ) {
	if( empty( $transient->checked['bookshop-2018'] ) )
	return $transient;

	$response = wp_remote_get( 'https://wp.cdi.ch/themes/bookshop-2018/update.json' );

	if( is_wp_error( $response ) ) {
		return false;
	}

	$result = wp_remote_retrieve_body( $response );
	$data = json_decode( $result );

	/* On vérifie la version sur le serveur par rapport à la version installée */
	if( ! empty( $data ) ) {
		if( version_compare( $transient->checked['bookshop-2018'], $data->new_version, '<' ) )
		$transient->response['bookshop-2018'] = (array) $data;
	}

	return $transient;
} 
add_filter ( 'pre_set_site_transient_update_themes', 'bookshop2018_update_notifier' );