<?php get_header( 'bookshop' ); ?>

<div role="main">
   <div id="home" class="section">
      <div class="site-content">
         <div class="presentation">
            <h1>Les fonctionnalités de Bookshop</h1>

            <div class="col-50">
               <div class="gestion">
                  <h2>Gestion</h2>
                  <p>Un outil de gestion complet, sur trois canaux de vente, couvrant l'intégralité des besoins fonctionnels des grandes et petites librairies, et s'adaptant aux nouvelles problématiques métier.</p>
               </div>
               <div class="electre">
                  <h3>Electre</h3>
                  <p>La qualité Electre au service de la gestion.
                  Bookshop intègre nativement les notices Electre livres, CD.</p>
               </div>
               <div class="interfaces">
                  <h3>Interfaces</h3>
                  <p>Bookshop est interfacé avec Dilicom, vos transporteurs, votre système comptable, et peut facilement l’être avec vos prestataires externes éventuels.</p>
               </div>
                              
            </div>

            <div class="col-50">
               <div class="mobilite">
                  <h3>Mobilité</h3>
                  <p>Améliorer votre productivité grâce à nos applications ergonomiques&nbsp;: picking, réception, préparation de livraison, conseil client, inventaire, retours.</p>
               </div>
               <div class="caisse">
                  <h3>Caisse</h3>
                  <p>Un système de caisse intuitif, ergonomique et mobile, conforme à la norme anti-fraude NF525.</p>
               </div>
               
               <div class="ecommerce">
                  <h3>E-commerce</h3>
                  <p>En partenariat avec eNovalp, une solution e-commerce tournée vers les contenus éditoriaux, alimentée par les notices Electre et permettant une intégration optimale des commandes Internet dans votre flux de gestion.</p>
               </div>

               
            </div>
         </div>
      </div>
   </div>

   <div class="clear"></div>

   <div id="tarificationmobile" class="section jaunebk">
      <div class="site-content">
         <h1>Demande de devis</h1>
         <p>Dans le cadre de l’implémentation du système Bookshop dans votre librairie, notre équipe projet analyse votre fonctionnement et élabore une tarification sur-mesure afin de vous proposer la solution optimale pour répondre à vos besoins métier.</p>
         <a href="/tarification" class="button">Tarification</a>
      </div>
   </div>

   <div id="documentation" class="section /tarification">
      <div class="site-content">
         <p>Une documentation complète décrivant les fonctionnalités détaillées de l’application Bookshop est disponible.</p>
         <a data-scroll href="#contact" class="button">Demande de documentation</a>
      </div>
   </div>

   <div class="clear"></div>

   <div id="references" class="section jaunebk">
      <div class="site-content">
         <div class="confiance">
            <h2>Ils nous font confiance</h2>
            
            <div class="icones">
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/baobab.png" width="200" height="200" alt="Librairie du Baobab - la librairie en mouvement" />
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/mollat.png" width="200" height="200" alt="Mollat - Station-Ausone" />
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/laliseuse.png" width="200" height="200" alt="La Liseuse Librairie" />
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/libro_phoros.png" width="200" height="200" alt="Libro Phoros" />
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/cinematheque.png" width="200" height="200" alt="La cinémathèque française" />
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/ici-librairie.png" width="200" height="200" alt="Ici librairie" />
            </div>

            <div class="clear"></div>

            <div class="citation">
               <div class="photorob">
                  <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/emmanuelle_robillard.png" width="317" height="317" alt="" />
               </div>
               
               <div class="textr">
                  <p>«&nbsp;L’application Bookshop nous offre une souplesse et une rapidité d’exécution rêvées. Nos libraires, nos logisticiens, nos services de commande et facturation sont enfin soulagés de tâches répétitives. Ils sont libérés de contraintes binaires pour découvrir le monde de la mobilité, du web, du design. Une révolution&nbsp;!&nbsp;»<br>
                  <em>– Emmanuelle Robillard, Directrice Projets et Qualité<br>
                  Librairie Mollat - Bordeaux<br>
                  </em>
                  <img class="logomollat" src="<?php echo get_stylesheet_directory_uri(); ?>/img/mollat.png" alt="logo Mollat" width="200" height="200" /></p>
               </div>
            </div>
         </div>
      </div>
   </div>

   <div id="newsletter">
      <div class="site-content">
         <h2>Abonnez-vous à la newsletter Bookshop</h2>
            <a href="https://sibforms.com/serve/MUIEAOO-60DBx9dqtd4dSEEX8mthgBOjGWdC5V4IB07gu0a2YuJo9f1-5YBGxRdlXsbuYZndJpwVDwXkeuxntrGwUfBPQNJSzoF6pTZAZ7V2jRX2CTknzePmX48lXeiaANtuUqscg8Iuoy0tJ9A1mHGrbbLGIrJfTg-eqxehyR7_kQo8vggOcP94A2hVqj2udIE8fnTXzaqO8dT6" class="button">
            S'inscrire à la newsletter
            </a>
      </div>
   </div>

   <div class="clear"></div>   


   <div id="CDI" class="section">
      <div class="site-content">
         <h2>Bookshop est développée par CDI, Conseils et Développements Informatiques</h2>
         
         <div class="citation">
            <div class="imgl">
               <img class="imgcdi" src="<?php echo get_stylesheet_directory_uri(); ?>/img/logo_cdi-france.svg" width="397" height="159" alt="CDI" />
            </div>
            
            <p>Créée en 2017, CDI France est une succursale la société CDI (Conseils et Développements Informatiques SA), établie à Fribourg, Suisse, spécialisée dans le développement applicatif, la conception de sites Internet et la gestion d’infrastructures informatiques.</br><a href="https://www.cdifrance.fr/" style="text-align:center" target="_blank">www.cdifrance.fr</a></p>  
         </div>
         
         <p>&nbsp;</p>
         
         <div class="citation">
            <div class="imgl">
               <img class="photocdi" src="<?php echo get_stylesheet_directory_uri(); ?>/img/david-lafarge.jpg" width="317" height="317" alt="" />
            </div>

            <div class="textr">
               <h3>David Lafarge</h3>
               <p>Responsable commercial et projets secteur librairie, France</p>
               <a href="mailto:%64&#108;%61&#64;c%64i%2ech">dla&#64;cdi.ch</a> 
            </div>
         </div>
      </div>
   </div>

   <div class="clear"></div>

   <?php while (have_posts()) : the_post(); ?>
   <div id="contact" class="section contact">
      <div class="site-content">
         <h2>Contactez-nous</h2>
         
         <?php the_content(); ?>

         <div class="clear"></div>
      </div>
   </div>
   <?php endwhile; // End the loop ?>

</div>

<?php get_footer( 'bookshop' ); ?>