<?php
/**
 * Fichier pour afficher les pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	Atep
 * @since	Atep 2.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">

			<?php
			/* Début de la boucle */
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/content', 'page' );

				/**
				 * Si les commentaires sont ouverts ou si on a au moins un commentaire,
				 * on charge le template des commentaires
				 */
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile;

			
			/**
			 * Slideshow en fond de page avec Vegas
			 * On vérifie s'il y a des images pour utiliser ou non le script
			 */
			if( have_rows( 'slideshow_home', 'options-slideshows' ) ):
			?>
				<script type="text/javascript">
					jQuery(function($) {
						$(document).ready(function () {
							/* Vegas Slideshow */
							$(".site-background").vegas({
								// shuffle: true,
								timer: false,
								delay: 6000,
								transitionDuration: 5000,
								slides: [
									<?php
									/* Si il y a des images, on récupère les URLs */
									while( have_rows( 'slideshow_home', 'options-slideshows' ) ): the_row(); 
									$slideshow_home = get_sub_field('slideshow_home_image');
									$slideshow_home_url = $slideshow_home['url'];
									?>
									{ src: "<?php echo $slideshow_home_url ?>" },
									<?php endwhile; ?>
								]
							});
						});
					})(jQuery);
				</script>
			<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer(); ?>
