<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Luc Poupard
 *
 * @package	Atep
 * @since	Atep 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon.png'; ?>">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-32x32.png'; ?>" sizes="32x32">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-16x16.png'; ?>" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/manifest.json'; ?>">
<meta name="theme-color" content="#ffffff">
<?php wp_head(); ?>
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<div id="site-top" class="site-wrapper">
	<div class="site-background"><?php /* Cette div sert à ajouter un fond qui aurait un positionnement particulier (fixé en bas de la fenêtre par exemple) */ ?></div>

	<div class="site-sticky-footer">
		<a href="#site-menu" class="screen-reader-text"><?php esc_html_e( 'Skip to navigation', 'cdiwp' ); ?></a>
		<a href="#site-content" class="screen-reader-text"><?php esc_html_e( 'Skip to content', 'cdiwp' ); ?></a>

		<header id="site-header" class="site-header" role="banner">
			<div class="site-header_wrapper">
				<div class="site-branding">
					<?php
					/* Si on est sur la page d'accueil du site, on affiche un titre de niveau 1… */
					if ( is_front_page() ) : ?>
						<h1 class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.svg'; ?>" width="200" alt="<?php bloginfo( 'name' ); ?>" /></a></h1>
					<?php
					/* …sinon on affiche un paragraphe */
					else : ?>
						<p class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.svg'; ?>" width="200" alt="<?php bloginfo( 'name' ); ?>" /></a></p>
					<?php endif; ?>
				</div><!-- .site-branding -->
				
				<div class="switch-lang">
					<ul>
						<?php
						/* @see https://polylang.wordpress.com/documentation/documentation-for-developers/functions-reference/ */
						pll_the_languages( array(
							'display_names_as'			=> 'slug',
							'hide_if_no_translation'	=> 1,
							'hide_current'				=> 1
						) );
						?>
					</ul>
				</div><!-- .switch-lang -->

				<div id="site-menu"><?php /* Cette div sert pour le lien d'évitement vers la navigation. Ne rien mettre entre #site-menu et #site-navigation */ ?></div>
				<nav id="site-navigation" class="site-navigation" role="navigation">
					<?php
						wp_nav_menu( array(
							'theme_location'	=> 'primary',
							'container'			=> false, // On ne crée pas de conteneur autour du menu
							'menu_class'		=> 'sf-menu', // On ajoute la class pour le menu superfish
							'menu_id'			=> 'primary-menu'
						) );
					?>
				</nav><!-- #site-navigation -->
				<a href="#site-navigation"><span><?php esc_html_e( 'Menu', 'cdiwp' ); ?></span></a>
			</div><!-- .site-header_wrapper -->
		</header><!-- #site-header -->

		<div id="site-content-wrapper" class="site-content-wrapper">
