<?php
/**
 * Atep : fonctions du thème.
 *
 * @link	https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author	Luc Poupard
 *
 * @package	Atep 2.2.0
 * @since	Atep 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Fonctions WordPress
		-- Traductions
		-- Menus de navigation
		-- Images à la Une
		-- Flux RSS
	== Widgets
	== Ajout des styles et scripts du thème 
		-- Styles
		-- Scripts
	== Fonctions externalisées
		-- Global
		-- Front
		-- Administration
*/


/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
	/* -- @subsection Traductions -------------------- */
	/**
	 * Préparer le thème pour traduction.
	 * Les traductions sont placées dans le répertoire /languages/
	 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdiwp' )
	 */
	load_child_theme_textdomain( 'cdiwpchild', get_stylesheet_directory() . '/languages' );


	/* -- @subsection Menus de navigation -------------------- */
	/**
	 * Déclaration du menu de navigation principal.
	 */
	// register_nav_menus( array(
	// 	'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
	// ) );


	/* -- @subsection Images à la Une -------------------- */
	/**
	 * On supprime le support des Images à la Une par défaut
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'post-thumbnails' );

	/* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
	// set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


	/* -- @subsection Flux RSS -------------------- */
	/**
	 * On supprime le support les adresses de flux dans <head>
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'automatic-feed-links' );	
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
function remove_cdiwpchild_widgets() {
	unregister_sidebar( 'sidebar-1' );
}
add_action( 'widgets_init', 'remove_cdiwpchild_widgets', 11 );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
// function cdiwpchild_widgets_init() {
// 	register_sidebar( array(
// 		'name'			=> esc_html__( 'Sidebar', 'cdiwp' ),
// 		'id'			=> 'sidebar-1',
// 		'description'	=> esc_html__( 'Add widgets here.', 'cdiwp' ),
// 		'before_widget'	=> '<aside id="%1$s" class="widget %2$s">',
// 		'after_widget'	=> '</aside>',
// 		'before_title'	=> '<div class="widget-title">',
// 		'after_title'	=> '</div>',
// 	) );
// }
// add_action( 'widgets_init', 'cdiwpchild_widgets_init' );


/* == @section Ajout des styles et scripts du thème ==================== */
function cdiwpchild_styles() {
	/* -- @subsection Styles -------------------- */
	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		'2.0.10',
		'all'
	);

	/* -- @subsection Scripts -------------------- */
	wp_register_script(
		'sticky-kit',
		get_stylesheet_directory_uri() . '/js/sticky-kit.1.1.3.min.js',
		false,
		null,
		true
	);
	
	wp_register_script(
		'vegas',
		get_stylesheet_directory_uri() . '/js/vegas.2.3.1.min.js',
		false,
		null,
		true
	);

	wp_register_script(
		'scripts',
		get_stylesheet_directory_uri() . '/js/scripts.js',
		false,
		null,
		true
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
	wp_enqueue_script( 'sticky-kit' );
	wp_enqueue_script( 'vegas' );
	wp_enqueue_script( 'scripts' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

	/* Ajouter des droits à des utilisateurs */
	require get_stylesheet_directory() . '/functions/admin_capabilities.php';

	/* Cacher des items du menu aux non administrateurs */
	require get_stylesheet_directory() . '/functions/admin_menu.php';

	/* Cacher les widgets du dashboard */
	// require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';

	/* Afficher une page d'option ACF dans l'admin */
	require get_stylesheet_directory() . '/functions/admin_acf.php';
}