<?php
/**
 * Template Name: Page d'accueil 
 *
 * Fichier pour afficher la page d'accueil.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	Atep
 * @since	Atep 2.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">
			<?php
			$description = get_bloginfo( 'description', 'display' );
			if ( $description || is_customize_preview() ) :
			?>
				<p class="site-header_description" lang="en"><?php echo $description; /* WPCS: xss ok. */ ?></p>
			<?php endif; ?>
			
			<?php
			/* Début de la boucle */
			while ( have_posts() ) : the_post();
			?>
				<div class="home-blocks clearfix">

					<?php if( have_rows('blocs_home') ): ?>
						<?php while( have_rows('blocs_home') ): the_row(); 
							$home_titre = get_sub_field('blocs_home_titre');
							$home_texte = get_sub_field('blocs_home_texte');
							$home_lien = get_sub_field('blocs_home_lien');
						?>

						<div class="home-block">
							<h2 class="home-block_title"><a href="<?php echo $home_lien; ?>"><?php echo $home_titre; ?></a></h2>

							<div class="home-block_content">
								<?php echo $home_texte; ?>
								
								<a href="<?php echo $home_lien; ?>" class="home-block_more"><?php esc_html_e( 'Plus…', 'cdiwpchild' ); ?></a>
							</div>
						</div>

						<?php endwhile; ?>

					<?php endif; ?>

				</div><!-- .home-blocks -->

				<?php // the_content(); ?>

				<?php
				/**
				 * Si les commentaires sont ouverts ou si on a au moins un commentaire,
				 * on charge le template des commentaires
				 */
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile;

			
			/**
			 * Slideshow en fond de page avec Vegas
			 * On vérifie s'il y a des images pour utiliser ou non le script
			 */
			if( have_rows( 'slideshow_home', 'options-slideshows' ) ):
			?>
				<script type="text/javascript">
					jQuery(function($) {
						$(document).ready(function () {
							/* Vegas Slideshow */
							$(".site-background").vegas({
								// shuffle: true,
								timer: false,
								delay: 6000,
								transitionDuration: 5000,
								slides: [
									<?php
									/* Si il y a des images, on récupère les URLs */
									while( have_rows( 'slideshow_home', 'options-slideshows' ) ): the_row(); 
									$slideshow_home = get_sub_field('slideshow_home_image');
									$slideshow_home_url = $slideshow_home['url'];
									?>
									{ src: "<?php echo $slideshow_home_url ?>" },
									<?php endwhile; ?>
								]
							});
						});
					})(jQuery);
				</script>
			<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer(); ?>
