<?php
/**
 * Pied de page
 *
 * C'est le template qui affiche la fermeture du contenu <div id="content">
 * et tout ce qui suit.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
?>

            <footer id="site-footer" class="site-footer" role="contentinfo">
                <div class="site-footer_info">
                    <p>
                        &copy; Livre Suisse <?php echo date( 'Y' ); ?>
                        <span class="sep" role="presentation" aria-hidden="true"> | </span>
                        <?php printf( esc_html__( 'Créé par', 'cdi-base-child' ) ); ?>
                        <a target="_blank" href="https://www2.cdi.ch/"><?php printf( esc_html__( 'CDI', 'cdi-base-child' ), 'cdi' ); ?></a>
                        <span class="sep" role="presentation" aria-hidden="true"> | </span>
                        Graphisme par <a target="_blank" href="https://www.ultrastudio.ch/">ultrastudio.ch</a>
                    </p>
                </div><!-- .site-footer_info -->
            </footer><!-- #site-footer -->
        </div><!-- .sidebar-footer -->
    </div><!-- #site-content-wrapper -->
</div><!-- #site-top -->

<div class="dialog" aria-hidden="true" id="my-accessible-dialog">
    <div class="dialog-overlay" tabindex="-1" data-a11y-dialog-hide></div>
    <div class="dialog-content" aria-labelledby="dialogTitle" aria-describedby="dialogDescription" role="dialog">
        <div role="document">
            <button data-a11y-dialog-hide class="dialog-close" aria-label="Close this dialog window">&times;</button>

            <?php if ( ! is_user_logged_in() ) : ?>

                <h1 id="dialogTitle"><?php echo __( 'Connexion', 'cdi-base-child' ) ?></h1>
                <?php wp_login_form(); ?>

            <?php else : ?>

                <h1 id="dialogTitle"><?php echo __( 'Déconnexion', 'cdi-base-child' ) ?></h1>
                <?php echo '<a href="' . wp_logout_url( site_url( '/' ) ) .'">' . __( 'Se déconnecter', 'cdi-base-child' ) . '</a>'; ?>

            <?php endif; ?>
        </div>
    </div>
</div>
