<?php
/**
 * Fichier partiel pour afficher le contenu des articles
 *
 * C'est le template par défaut pour afficher les articles.
 * Il est utilisé par défaut si aucun template n'est trouvé pour le format d'article.
 * 
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.0
 * @since	CDI_Base 2.0.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_single() ) :
			/* Si on est sur le détail de l'article on affiche un titre de niveau 1 */
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			/* Si on est sur une liste d'articles on afficheu un titre de niveau 2 */
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>

		<div class="entry-meta">
			<?php esc_html_e( 'Publié le', 'cdi-base-child'  ); ?>
			<span><?php the_date( 'd F Y' ); ?></span>
			<?php esc_html_e( 'par', 'cdi-base-child'  ); ?>
			<span><?php the_author(); ?></span>
		</div><!-- .entry-meta -->
		
		<?php
		endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'cdi-base-child' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );
			
			if ( function_exists( 'ffeeeedd__partage' ) ) {
				ffeeeedd__partage();
			}

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cdi-base-child' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php cdiwp_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
