<?php
/**
 * Fichier partiel pour afficher un message lorsqu'aucun article n'a été trouvé.
 * 
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.0
 * @since	CDI_Base 2.0.0
 */
?>

<div class="no-results not-found">
	<p>
		<?php esc_html_e( 'Il n’y a actuellement aucun membre de l’ASDEL dans ce canton.', 'cdi-base-child' ); ?><br />
		<?php esc_html_e( 'Veuillez choisir un autre canton ou réinitialiser le filtre.', 'cdi-base-child' ); ?>
	</p>

	<?php foreach( $GLOBALS['canton_filters'] as $key => $name ):
		// get the field's settings without attempting to load a value
		$field = get_field_object($key, false, false);
		
		// set value if available
		if( isset($_GET[ $name ]) ) {
			$field['value'] = $_GET[ $name ];
		}
		
		// create filter
		?>

		<div class="filtre-membre" data-filter="<?php echo $name; ?>">
			<label for="<?php echo 'acf-' . $field['key'] ?>"><?php echo __( 'Filtrer les membres par canton', 'cdi-base-child' ) ?></label>
			<?php create_field( $field ); ?>

			<?php if( $_GET['canton'] ) : ?>
				<a href="/membres/"><?php echo __( 'Réinitialiser', 'cdi-base-child' ) ?></a>
			<?php endif; ?>
		</div>
		
	<?php endforeach; ?>
</div><!-- .no-results .not-found -->
