<?php
/**
 * Fichier partiel pour afficher le contenu des pages
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.0
 * @since	CDI_Base 2.0.0
 */
?>

<div class="bloctexte lien-pratique">
	<?php 
		$personne_de_contact_bloc		= get_field( 'personne_de_contact_bloc' );
		$adresse_nom_bloc				= get_field( 'adresse_nom_bloc' );
		$adresse_nom_supplement_bloc	= get_field( 'adresse_nom_supplement_bloc' );
		$adresse_rue_bloc 				= get_field( 'adresse_rue_bloc' );
		$case_postale_bloc				= get_field( 'case_postale_bloc' );
		$adresse_npa_bloc				= get_field( 'adresse_npa_bloc' );
		$pays_bloc						= get_field( 'pays_bloc' );
		$telephone_bloc					= get_field( 'ctelephone_bloc' );
		$fax_bloc						= get_field( 'fax_bloc' );
		$email_bloc						= get_field( 'email_bloc' );
		$site_bloc						= get_field( 'site_bloc' );
	?>
	
	<h2><?php the_title(); ?></h2>

	<div class="lien-pratique__content"><?php the_content(); ?></div>

	<div class="lien-pratique__infos">
		<?php if( $personne_de_contact_bloc || $adresse_nom_bloc || $adresse_nom_supplement_bloc || $adresse_rue_bloc || $case_postale_bloc || $adresse_bloc_npa || $adresse_npa_bloc || $pays_bloc ) : ?>
			<address>
				<?php if( $personne_de_contact_bloc ) : ?>
					<?php echo $personne_de_contact_bloc; ?><br />
				<?php endif; ?>

				<?php if( $adresse_nom_bloc ) : ?>
					<?php echo $adresse_nom_bloc; ?><br />
				<?php endif; ?>

				<?php if( $adresse_nom_supplement_bloc ) : ?>
					<?php echo $adresse_nom_supplement_bloc; ?><br />
				<?php endif; ?>

				<?php if( $adresse_rue_bloc ) : ?>
					<?php echo $adresse_rue_bloc; ?><br />
				<?php endif; ?>

				<?php if( $case_postale_bloc ) : ?>
					<?php echo $case_postale_bloc; ?><br />
				<?php endif; ?>

				<?php if( $adresse_bloc_np ) : ?>
					<?php echo $adresse_bloc_npa; ?><br />
				<?php endif; ?>

				<?php if( $adresse_npa_bloc ) : ?>
					<?php echo $adresse_npa_bloc; ?><br />
				<?php endif; ?>

				<?php if( $pays_bloc ) : ?>
					<?php echo $pays_bloc; ?><br />
				<?php endif; ?>
			</address>
		<?php else: ?>
			<div><?php echo __( 'Adresse postale non renseignée', 'cdi-base-child' ) ?></div>
		<?php endif; ?>

		<?php if( $telephone_bloc || $fax_bloc || $email_bloc || $site_bloc ) : ?>
			<div>
				<?php if( $telephone_bloc ) : ?>
					<?php echo $telephone_bloc; ?><br />
				<?php endif; ?>

				<?php if( $fax_bloc ) : ?>
					<?php echo $fax_bloc; ?><br />
				<?php endif; ?>

				<?php if( $email_bloc ) : ?>
					<a href="mailto:<?php echo $email_bloc; ?>"><?php echo $email_bloc; ?></a><br />
				<?php endif; ?>

				<?php if( $site_bloc ) : ?>
					<a href="<?php echo $site_bloc['url']; ?>" target="<?php echo $site_bloc['target']; ?>" ><?php echo $site_bloc['title'];  ?></a></br>
				<?php endif; ?>
			</div>
		<?php else: ?>
			<div><?php echo __( 'Données de contact non renseignées', 'cdi-base-child' ) ?></div>
		<?php endif; ?>
	</div>
</div>