<?php
/**
 * Fichier partiel pour afficher le contenu des pages
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.0
 * @since	CDI_Base 2.0.0
 */
?>

<div class="events-list__item" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if( have_rows( 'evenement' ) ): ?>
		<?php while( have_rows( 'evenement' ) ): the_row(); 
			$event_intervenant	= get_sub_field( 'intervenant_bloc' );

			/* Date en français https://www.advancedcustomfields.com/resources/date-picker/ */
			$dateformatstring	= "j M Y";
			$unixtimestamp 		= strtotime( get_sub_field( 'date_bloc', false, false ) );

			$event_time 		= get_sub_field( 'heure_bloc' );
		?>

		<div class="events-list__item-type"><?php the_sub_field( 'type_bloc' ); ?></div>

		<h2 class="events-list__item-title"><?php the_title(); ?></h2>

		<div class="events-list__item-speaker"><?php echo $event_intervenant ?></div>

		<div class="events-list__item-infos">
			<span class="events-list__item-date"><?php echo date_i18n( $dateformatstring, $unixtimestamp ); ?></span>
			<?php if( $event_time ): ?>
				<span class="events-list__item-time"><?php echo $event_time; ?></span>
				<?php endif; ?>
			<span class="events-list__item-place"><?php the_sub_field( 'lieu_bloc' ); ?></span>
		</div>

		<a class="events-list__item-link" href="<?php the_permalink(); ?>"><?php esc_html_e( 'En savoir plus', 'cdi-base-child'  ); ?></a>

		<?php endwhile; ?>
	<?php endif; ?>
</div>
