<?php
/**
 * Fichier partiel pour afficher le contenu des articles
 *
 * C'est le template par défaut pour afficher les articles.
 * Il est utilisé par défaut si aucun template n'est trouvé pour le format d'article.
 * 
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.0
 * @since	CDI_Base 2.0.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );

			if ( 'post' === get_post_type() ) : ?>

			<div class="entry-meta">
				<?php esc_html_e( 'Publié le', 'cdi-base-child'  ); ?>
				<span><?php the_date( 'd F Y' ); ?></span>
				<?php esc_html_e( 'par', 'cdi-base-child'  ); ?>
				<span><?php the_author(); ?></span>
			</div><!-- .entry-meta -->
		
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_excerpt(); ?>
	</div><!-- .entry-content -->

	<div class="entry-more">
		<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Lire la suite de', 'cdi-base-child'  ); ?> «&nbsp;<?php the_title(); ?>&nbsp;»</a>
	</div>
</article><!-- #post-## -->
