<?php
/**
 * Fichier partiel pour afficher le contenu des pages
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.0
 * @since	CDI_Base 2.0.0
 */
?>

<article class="events-detail" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if( have_rows( 'evenement' ) ): ?>
		<?php while( have_rows( 'evenement' ) ): the_row(); 
			$event_intervenant	= get_sub_field( 'intervenant_bloc' );

			/* Date en français https://www.advancedcustomfields.com/resources/date-picker/ */
			$dateformatstring	= "j M Y";
			$unixtimestamp 		= strtotime( get_sub_field( 'date_bloc', false, false ) );

			$event_time 		= get_sub_field( 'heure_bloc' );
		?>

		<header>
			<h1 class="events-detail-title"><?php the_title(); ?></h1>
			<div class="events-detail-infos">
				<div class="events-detail-type"><?php the_sub_field( 'type_bloc' ); ?></div>

				<span class="events-detail-date"><?php echo date_i18n( $dateformatstring, $unixtimestamp ); ?></span>

				<?php if( $event_time ): ?>
					<span class="events-detail-time"><?php echo $event_time; ?></span>
				<?php endif; ?>
				<span class="events-detail-place"><?php the_sub_field( 'lieu_bloc' ); ?></span>

				<div class="events-detail-speaker"><?php echo $event_intervenant ?></div>
			</div>
		</header><!-- .entry-header -->

		<?php endwhile; ?>
	<?php endif; ?>

	<div class="entry-content">
		<?php
		the_content();

		if ( function_exists( 'ffeeeedd__partage' ) ) {
			ffeeeedd__partage();
		}
		?>
	</div><!-- .entry-content -->
</article>
