<?php
/**
 * Fichier pour afficher les archives
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">

		<?php
		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		$job_loop = new WP_Query( array(
			'post_type' => 'asdel_jobs',
			'nopaging' => false,
			'posts_per_page' => '10',
			'orderby' => 'date',
			'order' => 'DESC',
			'paged' => $paged
		) );

		if ( $job_loop->have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title"><?php the_title(); ?></h1>
			</header><!-- .page-header -->

			<ul class="jobs-list">
				<?php
				/* Début de la boucle */
				while ( $job_loop->have_posts() ) : $job_loop->the_post();

					/**
					 * On utilise des templates partiels en fonction du format d'article
					 * (Post Format : https://wpchannel.com/post-formats-wordpress/).
					 * Pour écraser ce partiel dans le thème enfant, ajouter un fichier
					 * content-___.php (où ___ est le nom du format d'article).
					 */
					get_template_part( 'template-parts/content', 'job' );

				endwhile; ?>
			<ul>
				
			<?php // https://codex.wordpress.org/Function_Reference/paginate_links#Example_With_a_Custom_Query
			$big = 999999999; // need an unlikely integer

			echo paginate_links( array(
				'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format' => '?page/%#%',
				'current' => max( 1, get_query_var('paged') ),
				'total' => $job_loop->max_num_pages
			) );

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif; ?>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
