<?php
/**
 * Fichier pour afficher les archives
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">

		<header class="page-header">
			<h1 class="page-title">
				<?php
				the_title();

				if( isset( $_GET['canton'] ) ) :
					echo '&nbsp;: ' . $_GET['canton'];
				endif;
				?>
			</h1>
		</header><!-- .page-header -->

		<?php
		$members_args = array(
			'post_type' => 'asdel_members',
			'nopaging' => false,
			'posts_per_page' => '15',
			'orderby' => 'title',
			'order' => 'ASC',
			'paged' => $paged
		);

		$members_args['meta_query'] = array();

		$members_args['meta_query'][] = array(
			'key' => 'bloc_membre_%_domaine_bloc',
			'value' => 'Diffuseurs',
			'compare' => '=',
		);
		
		if( isset( $_GET['canton'] ) ) :
			$members_args['meta_query'][] = array(
				'key' => 'bloc_membre_%_canton_bloc',
				'value' => $_GET['canton'],
				'compare' => '=',
			);
		endif;

		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		$members_loop = new WP_Query( $members_args );

		if ( $members_loop->have_posts() ) :

			foreach( $GLOBALS['canton_filters'] as $key => $name ):
				// get the field's settings without attempting to load a value
				$field = get_field_object( $key, false, false );
				
				// set value if available
				if( isset( $_GET[ $name ] ) ) {
					$field['value'] = $_GET[ $name ];
				}
				
				// create filter
				?>
				
				<div class="filtre-membre" data-filter="<?php echo $name; ?>">
					<label for="<?php echo 'acf-' . $field['key'] ?>"><?php echo __( 'Filtrer les membres par canton', 'cdi-base-child' ) ?></label>
					<?php create_field( $field ); ?>

					<?php if( isset( $_GET['canton'] ) ) { ?><a href="/membres/diffuseurs/"><?php echo __( 'Réinitialiser', 'cdi-base-child' ) ?></a><?php } ?>
				</div>
				
			<?php endforeach; ?>

			<div class="liste-membre">

				<?php
				/* Début de la boucle */
				while ( $members_loop->have_posts() ) : $members_loop->the_post();

					/**
					 * On utilise des templates partiels en fonction du format d'article
					 * (Post Format : https://wpchannel.com/post-formats-wordpress/).
					 * Pour écraser ce partiel dans le thème enfant, ajouter un fichier
					 * content-___.php (où ___ est le nom du format d'article).
					 */
					get_template_part( 'template-parts/content', 'membre' );

				endwhile; ?>

			</div>

			<?php // https://codex.wordpress.org/Function_Reference/paginate_links#Example_With_a_Custom_Query
			$big = 999999999; // need an unlikely integer

			echo paginate_links( array(
				'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format' => '?page/%#%',
				'current' => max( 1, get_query_var('paged') ),
				'total' => $members_loop->max_num_pages
			) );

		else :

			get_template_part( 'template-parts/content', 'membre_none' );

		endif; ?>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer( 'diffuseurs' );
