<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="format-detection" content="telephone=no">
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-117542686-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-117542686-1');
</script>
<?php wp_head(); ?>
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon.png'; ?>">
<link rel="icon" type="/img/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-32x32.png'; ?>" sizes="32x32">
<link rel="icon" type="/img/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-16x16.png'; ?>" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/site.manifest'; ?>">
<link rel="mask-icon" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/safari-pinned-tab.svg'; ?>" color="#dc0000">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="theme-color" content="#ffffff">
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<div class="site-background"><?php /* Cette div sert à ajouter un fond qui aurait un positionnement particulier (fixé en bas de la fenêtre par exemple) */ ?></div>

<div id="site-top" class="site-wrapper">
	<a href="#site-navigation" class="screen-reader-text"><span><?php esc_html_e( 'Skip to navigation', 'cdi-base-child' ); ?></span></a>
	<a href="#site-content" class="screen-reader-text"><span><?php esc_html_e( 'Skip to content', 'cdi-base-child' ); ?></span></a>
	<a href="#site-search" class="screen-reader-text"><span><?php esc_html_e( 'Skip to search', 'cdi-base-child' ); ?></span></a>

	<div class="wrapper-header">
		<header id="site-header" class="site-header" role="banner">
			<?php
			/* Si on est sur la page d'accueil du site, on affiche un titre de niveau 1… */
			if ( is_front_page() ) : ?>
				<h1 class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/livresuisse-logo.svg'; ?>" width="480" height="145" alt="<?php bloginfo( 'name' ); ?>" /></a></h1>
			<?php
			/* …sinon on affiche un paragraphe */
			else : ?>
				<div class="site-header_title h1"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/livresuisse-logo.svg'; ?>" width="480" height="145" alt="<?php bloginfo( 'name' ); ?>" /></a></div>
			<?php endif ?>
		</header><!-- #site-header -->

		<nav id="site-navigation" class="site-navigation" role="navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><span><?php esc_html_e( 'Menu', 'cdi-base-child' ); ?></span></button>
			<div id="menus">
				<?php wp_nav_menu( array(
					'theme_location' => 'primary',
					'menu_id' => 'primary-menu',
					'container' => false,
					'walker' => new Asdel_Menu_Walker()
				) ); ?>

				<?php if ( is_user_logged_in() && current_user_can( 'edit_posts' ) ) : ?>
					<div class="member-menu">
						<?php if ( current_user_can( 'upload_files' ) ) : ?>

							<div class="member-menu__title"><span><?php echo __( 'Espace membre', 'cdi-base-child' ) ?></span></div>
						
							<?php
							wp_nav_menu( array(
								'theme_location' => 'member_menu',
								'menu_id' => 'member-menu',
								'container' => false
							) );

						endif;

						if( ! current_user_can( 'edit_others_posts' ) && current_user_can( 'edit_posts' )) : ?>

							<ul class="member-admin-menu">
								<li><a href="/wp-admin/edit.php"><?php echo __( 'Soumettre un article', 'cdi-base-child' ) ?></a></li>
								<li><a href="/wp-admin/profile.php"><?php echo __( 'Profil', 'cdi-base-child' ) ?></a></li>
							</ul>

						<?php endif; ?>
					</div>
				<?php endif ?>
			</div>
		</nav><!-- #site-navigation -->
	</div>

	<div id="site-content-wrapper" class="site-content-wrapper">
		<div class="site-topbar">
			<div id="site-search" class="site-search">
				<?php get_search_form() ?>

				<div class="site-user">
					<?php if ( ! is_user_logged_in() ) {
						echo '<button type="button" class="site-user__icon" data-a11y-dialog-show="my-accessible-dialog">' . __( 'Se connecter', 'cdi-base-child' ) . '</button>';
					} else {
						echo '<a href="' . wp_logout_url( site_url( '/' ) ) .'" class="site-user__icon">' . __( 'Se déconnecter', 'cdi-base-child' ) . '</a>';
					} ?>
				</div>
			</div>
		</div>

		<?php if ( function_exists( 'ffeeeedd__ariane' ) && !is_front_page() ) {
			ffeeeedd__ariane();
		} ?>
