<?php
/**
 * Fonction pour cacher des items de la barre d'admin
 *
 * @author	Luc Poupard
 * @link	https://www.smashingmagazine.com/2012/05/adding-custom-fields-in-wordpress-comment-form/
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


// Modification du formulaire de commentaires
add_filter( 'comment_form_defaults','changing_comment_form_defaults' );
function changing_comment_form_defaults($defaults){
    $defaults['comment_notes_before'] = '';

    $defaults['comment_field'] = '
        <p class="comment-form-comment">
            <label for="comment">' . __( 'Comment', 'cdi-base-child' ) . ' <span class="required small">'. __( '(Champ obligatoire)', 'cdi-base-child' ) .'</span></label>
            <textarea id="comment" name="comment" cols="45" rows="8" aria-required="true" required></textarea>
        </p>
    ';
    return $defaults;
}

add_filter( 'comment_form_defaults', 'fields_html5' );
if ( !function_exists('fields_html5')) {
    function fields_html5( $fields ) {
        // Type author
        $fields['fields']['author'] = '
            <p class="comment-form-author">
                <label for="author">'. __( 'Name', 'cdi-base-child' ) .' <span class="required small">'. __( '(Champ obligatoire)', 'cdi-base-child' ) .'</span></label>
                <input type="text" id="author" name="author" value="" aria-required="true" required size="30" />
            </p>
        ';
        // Type email
        $fields['fields']['email'] = '
            <p class="comment-form-email">
                <label for="email">'. __( 'Email', 'cdi-base-child' ) .' <span class="required small">'. __( '(Champ obligatoire)', 'cdi-base-child' ) .'</span></label>
                <input type="email" id="email" name="email" value="" aria-required="true" required size="30" />
            </p>
        ';
        // Type url et placeholder http://
        $fields['fields']['url'] = '
            <p class="comment-form-url">
                <label for="url">'. __( 'Website', 'cdi-base-child' ) .'</label>
                <input type="url" id="url" name="url" value="" placeholder="http://" size="30" />
            </p>
        ';
        // Bot trap
        $fields['fields']['gandalf'] = '
            <p class="comment-form-gandalf">
                <label for="gandalf">'. __( 'Spam trap', 'cdi-base-child' ) .'</label>
                <input type="text" id="gandalf" name="gandalf" value="" size="30" />
            </p>
        ';
    return $fields;
    }
}

/* https://gist.github.com/Coopeh/2962023 */
add_filter( 'preprocess_comment', 'check_comment_spam' );
function check_comment_spam( $commentdata ) {
    global $wp;
    $current_url = $_SERVER['HTTP_REFERER'];

    if ( isset( $_POST['gandalf'] ) && $_POST['gandalf'] != '' ) {
        wp_safe_redirect( $current_url );
        exit;
    } else {
        return $commentdata;
    }
}