<?php
/**
 * Nettoyage des classes générées de la navigation
 *
 * De multiples classes CSS sont ajoutées dans le menu et sont foncièrement inutiles.
 *
 * @author	Luc Poupard
 *
 * @link	https://github.com/ffoodd/ffeeeedd
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


class Asdel_Menu_Walker extends Walker_Nav_Menu {
	/*
	// lorsqu’un niveau commence (<ul>+content)
	function start_lvl( &$output, $depth, $args ) {
		// $output correspond à la variable retournée en fin de walker
		// $depth correspond à la profondeur du niveau
		// $arg aux variable supplémentaires
	}

	// lorsqu’un élément est initialisé (<li>+content)
	function start_el( &$output, $item, $depth, $args ) {
		// $output correspond à la variable retournée en fin de walker
		// $item correspond aux information sur l'item en cours
		// $depth correspond à la profondeur du niveau
		// $arg aux variable supplémentaires
	}

	// lorsqu’un élément se termine (</li>)
	function end_el( &$output, $item, $depth, $args ) {
		// $output correspond à la variable retournée en fin de walker
		// $item correspond aux information sur l'item en cours
		// $depth correspond à la profondeur du niveau
		// $arg aux variable supplémentaires
	}

	// lorsqu’un niveau se termine (</ul>)
	function end_lvl( &$output, $depth, $args ) {
		// $output correspond à la variable retournée en fin de walker
		// $depth correspond à la profondeur du niveau
		// $arg aux variable supplémentaires
	}
	*/
	
	/**
	 * Tout le code suivant est repris de la fonction existante
	 * https://developer.wordpress.org/reference/classes/walker_nav_menu/start_el/#source
	 * Sauf le code en commentaire, plus bas
	 */
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
			$t = '';
			$n = '';
		} else {
			$t = "\t";
			$n = "\n";
		}
		$indent = str_repeat( $t, $depth );

		/* Code ajouté */
		// Default class.
		// $classes = array( 'sub-menu' );
		$classes = array( 'sub-menu', 'js-to_expand' );
		/* Code ajouté */

		$class_names = join( ' ', apply_filters( 'nav_menu_submenu_css_class', $classes, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		$output .= "{$n}{$indent}<ul$class_names>{$n}";
	}

	/**
	 * Tout le code suivant est repris de la fonction existante
	 * https://developer.wordpress.org/reference/classes/walker_nav_menu/start_el/#source
	 * Sauf le code en commentaire, plus bas
	 */
	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
			$t = '';
			$n = '';
		} else {
			$t = "\t";
			$n = "\n";
		}
		$indent = ( $depth ) ? str_repeat( $t, $depth ) : '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		$args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth );
		$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

		$output .= $indent . '<li' . $id . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )     ? $item->target     : '';
		$atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
		$atts['href']   = ! empty( $item->url )        ? $item->url        : '';

		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}

		$title = apply_filters( 'the_title', $item->title, $item->ID );

		$title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );

		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>';
		$item_output .= $args->link_before . $title . $args->link_after;
		$item_output .= '</a>';

		/* Code ajouté */
		if( in_array( 'menu-item-has-children', $item->classes ) ) {
			$item_output .= '<span class="js-expandmore">' . esc_attr( __( 'Ouvrir le sous-menu ', 'cdi-base-child' ) ) . $title . '</span>';
		}
		/* Code ajouté */

		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}