<?php
/**
 * @author Luc Poupard
 * Code pour les pages membres
 */


/* == @section Requête sur champs ACF ==================== */
function my_posts_where( $where ) {
	global $wpdb;
	$where = str_replace(
		"meta_key = 'bloc_membre_%",
		"meta_key LIKE 'bloc_membre_%",
		$wpdb->remove_placeholder_escape($where)
	);
	return $where;
}
add_filter( 'posts_where', 'my_posts_where' );


/* == @section Filtres par canton ==================== */
/* https://www.advancedcustomfields.com/resources/creating-wp-archive-custom-field-filter/ */
// array of filters (field key => field name)
$GLOBALS['canton_filters'] = array( 
	'field_5a2e7ca2b2170' => 'canton_bloc'
);

// action
add_action( 'pre_get_posts', 'my_pre_get_posts', 10, 1 );
function my_pre_get_posts( $query ) {
	// bail early if is in admin
	if( is_admin() ) return;
	
	// bail early if not main query
	// - allows custom code / plugins to continue working
	if( !$query->is_main_query() ) return;
	
	// get meta query
	$meta_query = $query->get( 'meta_query' );
	
	// loop over filters
	foreach( $GLOBALS['canton_filters'] as $key => $name ) {
		// continue if not found in url
		if( empty( $_GET[ $name ] ) ) {
			continue;
		}
		
		// get the value for this filter
		// eg: http://www.website.com/events?city=melbourne,sydney
		$value = $_GET[ $name ];		
		
		// append meta query
    	$meta_query[] = array(
            'key'		=> $name,
            'value'		=> $value,
            'compare'	=> '=',
        );        
	} 	
	
	// update meta query
	$query->set('meta_query', $meta_query);
}