<?php
/**
 * Création des types de contenus personnalisés
 *
 * Générateur : https://generatewp.com/post-type/
 *
 * @author	Luc Poupard
 *
 * @package	Asdel 1.0.0
 * @since	Asdel 1.0.0
 */

function cpt_asdel() {
	// Membres
	$labels_members = array(
		'name'                  => _x( 'Membres', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Membre', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Membres', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Membre', 'cdi-base-child' ),
		'archives'              => __( 'Archives des membres', 'cdi-base-child' ),
		'attributes'            => __( 'Attributs du membre', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Parent du membre :', 'cdi-base-child' ),
		'all_items'             => __( 'Tous les membres', 'cdi-base-child' ),
		'add_new_item'          => __( 'Ajouter un membre', 'cdi-base-child' ),
		'add_new'               => __( 'Ajouter', 'cdi-base-child' ),
		'new_item'              => __( 'Nouveau membre', 'cdi-base-child' ),
		'edit_item'             => __( 'Modifier le membre', 'cdi-base-child' ),
		'update_item'           => __( 'Mettre à jour le membre', 'cdi-base-child' ),
		'view_item'             => __( 'Voir le membre', 'cdi-base-child' ),
		'view_items'            => __( 'Voir les membres', 'cdi-base-child' ),
		'search_items'          => __( 'Chercher un membre', 'cdi-base-child' ),
		'not_found'             => __( 'Aucun résultat', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Aucun résultat dans la corbeille', 'cdi-base-child' ),
		'featured_image'        => __( 'Image à la une', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Ajouter une image à la une', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Supprimer l’image à la une', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Utiliser comme image à la une', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Ajouter au membre', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Ajouter à ce membre', 'cdi-base-child' ),
		'items_list'            => __( 'Liste des membres', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Navigation dans la liste des membres', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filter la liste des membres', 'cdi-base-child' ),
	);
	$rewrite_members = array(
		'slug'                  => 'membre',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => false,
	);
	$args_members = array(
		'label'                 => __( 'Membre', 'cdi-base-child' ),
		'description'           => __( 'Liste des membres de l’asdel', 'cdi-base-child' ),
		'labels'                => $labels_members,
		'supports'              => array( 'title', 'editor', 'custom-fields', 'page-attributes' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-id-alt',
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite_members,
		'capability_type'       => 'page',
		'show_in_rest'          => true,
	);
	register_post_type( 'asdel_members', $args_members );

	// Organisation
	// $labels_organisation = array(
	// 	'name'                  => _x( 'Orgnisation', 'Post Type General Name', 'cdi-base-child' ),
	// 	'singular_name'         => _x( 'Orgnisation', 'Post Type Singular Name', 'cdi-base-child' ),
	// 	'menu_name'             => __( 'Organisation', 'cdi-base-child' ),
	// 	'name_admin_bar'        => __( 'Organisation', 'cdi-base-child' ),
	// 	'archives'              => __( 'Archives de l’organisation', 'cdi-base-child' ),
	// 	'attributes'            => __( 'Attributs du membre', 'cdi-base-child' ),
	// 	'parent_item_colon'     => __( 'Parent du membre :', 'cdi-base-child' ),
	// 	'all_items'             => __( 'Tous les membres', 'cdi-base-child' ),
	// 	'add_new_item'          => __( 'Ajouter un membre', 'cdi-base-child' ),
	// 	'add_new'               => __( 'Ajouter', 'cdi-base-child' ),
	// 	'new_item'              => __( 'Nouveau membre', 'cdi-base-child' ),
	// 	'edit_item'             => __( 'Modifier le membre', 'cdi-base-child' ),
	// 	'update_item'           => __( 'Mettre à jour le membre', 'cdi-base-child' ),
	// 	'view_item'             => __( 'Voir le membre', 'cdi-base-child' ),
	// 	'view_items'            => __( 'Voir les membres', 'cdi-base-child' ),
	// 	'search_items'          => __( 'Chercher un membre', 'cdi-base-child' ),
	// 	'not_found'             => __( 'Aucun résultat', 'cdi-base-child' ),
	// 	'not_found_in_trash'    => __( 'Aucun résultat dans la corbeille', 'cdi-base-child' ),
	// 	'featured_image'        => __( 'Image à la une', 'cdi-base-child' ),
	// 	'set_featured_image'    => __( 'Ajouter une image à la une', 'cdi-base-child' ),
	// 	'remove_featured_image' => __( 'Supprimer l’image à la une', 'cdi-base-child' ),
	// 	'use_featured_image'    => __( 'Utiliser comme image à la une', 'cdi-base-child' ),
	// 	'insert_into_item'      => __( 'Ajouter au membre', 'cdi-base-child' ),
	// 	'uploaded_to_this_item' => __( 'Ajouter à ce membre', 'cdi-base-child' ),
	// 	'items_list'            => __( 'Liste des membres', 'cdi-base-child' ),
	// 	'items_list_navigation' => __( 'Navigation dans la liste des membres', 'cdi-base-child' ),
	// 	'filter_items_list'     => __( 'Filter la liste des membres', 'cdi-base-child' ),
	// );
	// $rewrite_organisation = array(
	// 	'slug'                  => 'organisation',
	// 	'with_front'            => true,
	// 	'pages'                 => true,
	// 	'feeds'                 => false,
	// );
	// $args_organisation = array(
	// 	'label'                 => __( 'Orgnisation', 'cdi-base-child' ),
	// 	'description'           => __( 'Organisation de l’asdel', 'cdi-base-child' ),
	// 	'labels'                => $labels_organisation,
	// 	'supports'              => array( 'title', 'editor', 'custom-fields', 'page-attributes' ),
	// 	// 'taxonomies'            => array( 'category', 'post_tag' ),
	// 	'hierarchical'          => false,
	// 	'public'                => true,
	// 	'show_ui'               => true,
	// 	'show_in_menu'          => true,
	// 	'menu_position'         => 20,
	// 	'menu_icon'             => 'dashicons-networking',
	// 	'show_in_admin_bar'     => false,
	// 	'show_in_nav_menus'     => true,
	// 	'can_export'            => true,
	// 	'has_archive'           => false,
	// 	'exclude_from_search'   => false,
	// 	'publicly_queryable'    => true,
	// 	'rewrite'               => $rewrite_organisation,
	// 	'capability_type'       => 'page',
	// 	'show_in_rest'          => true,
	// );
	// register_post_type( 'asdel_organisation', $args_organisation );

	// Événements
	$labels_events = array(
		'name'                  => _x( 'Événements', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Événement', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Événements', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Événements', 'cdi-base-child' ),
		'archives'              => __( 'Archives des événements', 'cdi-base-child' ),
		'attributes'            => __( 'Attributs de l’événement', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Événement parent :', 'cdi-base-child' ),
		'all_items'             => __( 'Tous les événements', 'cdi-base-child' ),
		'add_new_item'          => __( 'Ajouter un événement', 'cdi-base-child' ),
		'add_new'               => __( 'Ajouter', 'cdi-base-child' ),
		'new_item'              => __( 'Nouvel événement', 'cdi-base-child' ),
		'edit_item'             => __( 'Modifier l’événement', 'cdi-base-child' ),
		'update_item'           => __( 'Mettre à jour l’événement', 'cdi-base-child' ),
		'view_item'             => __( 'Voir l’événement', 'cdi-base-child' ),
		'view_items'            => __( 'Voir les événements', 'cdi-base-child' ),
		'search_items'          => __( 'Chercher un événement', 'cdi-base-child' ),
		'not_found'             => __( 'Aucun résultat', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Aucun résultat dans la corbeille', 'cdi-base-child' ),
		'featured_image'        => __( 'Image à la une', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Ajouter une image à la une', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Supprimer l’image à la une', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Utiliser comme image à la une', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Ajouter à l’événement', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Ajouter à cet événement', 'cdi-base-child' ),
		'items_list'            => __( 'Liste des événements', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Navigation dans la liste des événements', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filter la liste des événements', 'cdi-base-child' ),
	);
	$rewrite_events = array(
		'slug'                  => 'evenement',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	$args_events = array(
		'label'                 => __( 'Événement', 'cdi-base-child' ),
		'description'           => __( 'Liste des événements de l’asdel', 'cdi-base-child' ),
		'labels'                => $labels_events,
		'supports'              => array( 'title', 'editor', 'custom-fields', 'page-attributes', 'thumbnail' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-calendar-alt',
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite_events,
		'capability_type'       => 'page',
		'show_in_rest'          => true,
	);
	register_post_type( 'asdel_events', $args_events );

	// Liens pratiques
	$labels_links = array(
		'name'                  => _x( 'Liens pratiques', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Lien pratique', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Liens pratiques', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Lien pratique', 'cdi-base-child' ),
		'archives'              => __( 'Archives des liens', 'cdi-base-child' ),
		'attributes'            => __( 'Attributs du lien', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Lien parent :', 'cdi-base-child' ),
		'all_items'             => __( 'Tous les liens', 'cdi-base-child' ),
		'add_new_item'          => __( 'Ajouter un lien', 'cdi-base-child' ),
		'add_new'               => __( 'Ajouter', 'cdi-base-child' ),
		'new_item'              => __( 'Nouveau lien', 'cdi-base-child' ),
		'edit_item'             => __( 'Modifier le lien', 'cdi-base-child' ),
		'update_item'           => __( 'Mettre à jour le lien', 'cdi-base-child' ),
		'view_item'             => __( 'Voir le lien', 'cdi-base-child' ),
		'view_items'            => __( 'Voir les liens', 'cdi-base-child' ),
		'search_items'          => __( 'Chercher un lien', 'cdi-base-child' ),
		'not_found'             => __( 'Aucun résultat', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Aucun résultat dans la corbeille', 'cdi-base-child' ),
		'featured_image'        => __( 'Image à la une', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Ajouter une image à la une', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Supprimer l’image à la une', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Utiliser comme image à la une', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Ajouter au lien', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Ajouter à ce lien', 'cdi-base-child' ),
		'items_list'            => __( 'Liste des liens', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Navigation dans la liste des liens', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filter la liste des liens', 'cdi-base-child' ),
	);
	$rewrite_links = array(
		'slug'                  => 'lien',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	$args_links = array(
		'label'                 => __( 'Lien pratique', 'cdi-base-child' ),
		'description'           => __( 'Liste des liens pratiques de l’asdel', 'cdi-base-child' ),
		'labels'                => $labels_links,
		'supports'              => array( 'title', 'editor', 'custom-fields', 'page-attributes' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-admin-site',
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite_links,
		'capability_type'       => 'page',
		'show_in_rest'          => true,
	);
	register_post_type( 'asdel_links', $args_links );

	// Offres d'emploi
	$labels_jobs = array(
		'name'                  => _x( 'Offres d’emploi', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Offre d’emploi', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Offres d’emploi', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Offre d’emploi', 'cdi-base-child' ),
		'archives'              => __( 'Archives des offres d’emploi', 'cdi-base-child' ),
		'attributes'            => __( 'Attributs de l’offre', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Lien parent :', 'cdi-base-child' ),
		'all_items'             => __( 'Toutes les offres', 'cdi-base-child' ),
		'add_new_item'          => __( 'Ajouter une offre', 'cdi-base-child' ),
		'add_new'               => __( 'Ajouter', 'cdi-base-child' ),
		'new_item'              => __( 'Nouvelle offre', 'cdi-base-child' ),
		'edit_item'             => __( 'Modifier l’offre', 'cdi-base-child' ),
		'update_item'           => __( 'Mettre à jour l’offre', 'cdi-base-child' ),
		'view_item'             => __( 'Voir l’offre', 'cdi-base-child' ),
		'view_items'            => __( 'Voir les offres', 'cdi-base-child' ),
		'search_items'          => __( 'Chercher une offre', 'cdi-base-child' ),
		'not_found'             => __( 'Aucun résultat', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Aucun résultat dans la corbeille', 'cdi-base-child' ),
		'featured_image'        => __( 'Image à la une', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Ajouter une image à la une', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Supprimer l’image à la une', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Utiliser comme image à la une', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Ajouter à l’offre', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Ajouter à cette offre', 'cdi-base-child' ),
		'items_list'            => __( 'Liste des offres', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Navigation dans la liste des offres', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filter la liste des offres', 'cdi-base-child' ),
	);
	$rewrite_jobs = array(
		'slug'                  => 'offre',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	$args_jobs = array(
		'label'                 => __( 'Offre d’emploi', 'cdi-base-child' ),
		'description'           => __( 'Liste des offres d’emploi de l’asdel', 'cdi-base-child' ),
		'labels'                => $labels_jobs,
		'supports'              => array( 'title', 'editor', 'custom-fields', 'page-attributes' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-megaphone',
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite_jobs,
		'capability_type'       => 'page',
		'show_in_rest'          => true,
	);
	register_post_type( 'asdel_jobs', $args_jobs );

	// Actualités
	$labels_news = array(
		'name'                  => _x( 'Actualités', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Actualité', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Actualités', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Actualité', 'cdi-base-child' ),
		'archives'              => __( 'Archives des actualités', 'cdi-base-child' ),
		'attributes'            => __( 'Attributs de l’actualité', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Actualité parente :', 'cdi-base-child' ),
		'all_items'             => __( 'Toutes les actualités', 'cdi-base-child' ),
		'add_new_item'          => __( 'Ajouter une actualité', 'cdi-base-child' ),
		'add_new'               => __( 'Ajouter', 'cdi-base-child' ),
		'new_item'              => __( 'Nouvelle actualité', 'cdi-base-child' ),
		'edit_item'             => __( 'Modifier l’actualité', 'cdi-base-child' ),
		'update_item'           => __( 'Mettre à jour l’actualité', 'cdi-base-child' ),
		'view_item'             => __( 'Voir l’actualité', 'cdi-base-child' ),
		'view_items'            => __( 'Voir les actualités', 'cdi-base-child' ),
		'search_items'          => __( 'Chercher une actualité', 'cdi-base-child' ),
		'not_found'             => __( 'Aucun résultat', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Aucun résultat dans la corbeille', 'cdi-base-child' ),
		'featured_image'        => __( 'Image à la une', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Ajouter une image à la une', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Supprimer l’image à la une', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Utiliser comme image à la une', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Ajouter à l’actualité', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Ajouter à cette actualité', 'cdi-base-child' ),
		'items_list'            => __( 'Liste des actualités', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Navigation dans la liste des actualités', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filtrer la liste des actualités', 'cdi-base-child' ),
	);
	$rewrite_news = array(
		'slug'                  => 'actualite',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	$args_news = array(
		'label'                 => __( 'Actualité', 'cdi-base-child' ),
		'description'           => __( 'Liste des actualités de l’asdel', 'cdi-base-child' ),
		'labels'                => $labels_news,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'page-attributes' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-microphone',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite_news,
		'capability_type'       => 'post',
	);
	register_post_type( 'asdel_news', $args_news );
}
add_action( 'init', 'cpt_asdel', 0 );