<?php
/**
 * @author Daniel Roch
 * @see https://twitter.com/rochdaniel
 * @see http://www.seomix.fr/fil-dariane-chemin-navigation/
 * @see http://support.google.com/webmasters/bin/answer.py?hl=fr&answer=185417
 * @note Modifications :
 * @author Gaël Poupard
 * @see https://twitter.com/ffoodd_fr
 * @note Prise en compte des formats d’articles, corrections des intitulés pour les taxonomies, du nombre de résultats et de la requête de la recherche, et mise en place des microdonnées au lieu des microformats.
 * @note Bonus : le séparateur est masqué pour les technologies d’assistance.
 * @see https://gist.github.com/jonathantneal/4037764
 * @note Bonus 2 : on se réfère au modèle proposé par la WAI :
 * @see http://www.w3.org/WAI/tutorials/menus/multiple-ways/#breadcrumbs
 * @note Nous sommes obligés de conserver des <div> et <span> pour supporter les microdonnées :
 * @note Si vous n’avez pa besoin des micros-données, supprimez-les :)
 */

/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Récupération des catégories parentes et ajout des microdonnées
	== Génération du fil d’Ariane
	== Notifications de mise à jour
*/


/* == @section Récupération des catégories parentes et ajout des microdonnées ==================== */
function ffeeeedd__categories( $id, $link = false, $separator = '<span class="breadcrumb-separator" aria-hidden="true"></span>', $nicename = false, $visited = array() ) {
	$final = '';
	$parent = get_category( $id );

	if ( is_wp_error( $parent ) ) {
		return $parent;
	}

	if ( $nicename ) {
		$name = $parent->name;
	} else {
		$name = $parent->cat_name;
	}

	if ( $parent->parent && ( $parent->parent != $parent->term_id ) && !in_array( $parent->parent, $visited ) ) {
		$visited[] = $parent->parent;
		$final .= ffeeeedd__categories( $parent->parent, $link, $separator, $nicename, $visited );
	}

	if ( $link ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( get_category_link( $parent->term_id ) ) . '" title="' . esc_attr( __( 'All entries in ', 'cdi-base-child' ) ) . esc_attr( $parent->cat_name ) . '" itemprop="url"><span itemprop="title">' . $name . '</span></a>' . $separator . '</div>';
	} else {
		$final .= $name . $separator;
	}

	return $final;
}


/* == @section Génération du fil d’Ariane ==================== */
function ffeeeedd__ariane() {
	// Variables globales
	global $wp_query;
	$paged = get_query_var( 'paged' );
	$sep = '<span class="breadcrumb-separator" aria-hidden="true"></span>';
	$final = '<nav role="navigation" aria-label="' . esc_attr( __( 'You are here: ', 'cdi-base-child' ) ) . '" class="breadcrumb">';
	$startdefault = '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( home_url() ) . '" itemprop="url"><span itemprop="title">' . esc_attr( __( 'Home', 'cdi-base-child' ) ) . '</span></a>' . $sep . '</div>';
	$starthome = esc_attr( __( 'Home', 'cdi-base-child' ) );
	
	// Début du fil d’Ariane
	if ( is_front_page() && is_home() ) {
		// Accueil par défaut
		if ( $paged >= 1 ) {
			$final .= $startdefault;
		} else {
			$final .= $starthome;
		}
	} elseif ( is_front_page() ) {
		// Accueil statique ( page statique définie )
		$final .= $starthome;
	} elseif ( is_home() ) {
	// Page de blog ( liste des articles )
		if ( $paged >= 1 ) {
			$url = get_page_link( get_option( 'page_for_posts' ) );
			$final .= $startdefault . '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( $url  ) . '" itemprop="url" title="' . esc_attr_e( 'Entries', 'cdi-base-child' ) . '"><span itemprop="title">' . __( 'Entries', 'cdi-base-child' ) . '</span></a></div>';
		} else {
			$final .= $startdefault . '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( 'Entries', 'cdi-base-child' ) . '</span></div>';
		}
	} else {
		// Pour tout le reste
		$final .= $startdefault;
	}
	
	// Empêche d'autre(s) code(s) d’interférer avec l’accueil statique ou blog
	if ( is_front_page() && is_home() ) {
	} elseif ( is_front_page() ) {
	} elseif ( is_home() ) {
	}
	//  Fichiers attachés
	elseif ( is_attachment() ) {
		global $post;
		$parent = get_post( $post->post_parent );
		$id = $parent->ID;
		$category = get_the_category( $id );
		$category_id = get_cat_ID( $category[0]->cat_name );
		$permalink = get_permalink( $id );
		$title = $parent->post_title;
		$final .= ffeeeedd__categories( $category_id, true, $sep ) . '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( $permalink ) . '" itemprop="url" title="' . esc_attr( $title ) . '"><span itemprop="title">' . $title . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . the_title('', '', false ) . '</span></div>';
	}
	// Type(s) d’articles
	/* Code ajouté pour Asdel */
	elseif ( is_single() && is_singular( 'asdel_events' ) ) {
		global $post;
		$nom = get_post_type( $post );
		$mypost = $post->post_title;
		$label = get_post_type_object( $nom )->labels->name;
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="/evenements" itemprop="url" title="' . esc_attr( $label ) . '"><span itemprop="title">' . $label . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $mypost . '</span></div>';
	}
	elseif ( is_single() && is_singular( 'asdel_jobs' ) ) {
		global $post;
		$nom = get_post_type( $post );
		$mypost = $post->post_title;
		$label = get_post_type_object( $nom )->labels->name;
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="/offres-demplois" itemprop="url" title="' . esc_attr( $label ) . '"><span itemprop="title">' . $label . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $mypost . '</span></div>';
	}
	elseif ( is_single() && is_singular( 'asdel_news' ) ) {
		global $post;
		$nom = get_post_type( $post );
		$mypost = $post->post_title;
		$label = get_post_type_object( $nom )->labels->name;
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="/actualites-du-livre" itemprop="url" title="' . esc_attr( $label ) . '"><span itemprop="title">' . $label . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $mypost . '</span></div>';
	}
	/* Code ajouté pour Asdel */
	elseif ( is_single() && !is_singular( 'post' ) ) {
		global $post;
		$nom = get_post_type( $post );
		$archive = get_post_type_archive_link( $nom );
		$mypost = $post->post_title;
		$label = get_post_type_object( $nom )->labels->name;
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( $archive ) . '" itemprop="url" title="' . esc_attr( $label ) . '"><span itemprop="title">' . $label . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $mypost . '</span></div>';
	}
	// Articles avec un format
	elseif ( is_single() && has_term('', 'post_format') ) {
		global $post;
		$format = get_post_format( $post->ID );
		$pretty_format = get_post_format_string( $format );
		$format_link = get_post_format_link( $format );
		$mypost = $post->post_title;
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( $format_link ) . '" itemprop="url" title="' . esc_attr( $pretty_format ) . '"><span itemprop="title">' . $pretty_format . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $mypost . '</span></div>';
	}
	// Articles sans format
	elseif ( is_single() && !has_term('', 'post_format') ) {
		// Catégories d’articles
		$category = get_the_category();
		$category_id = get_cat_ID( $category[0]->cat_name );
		
		if ( $category_id != 0 ) {

			/* Code modifié pour Asdel */
			// $final .= ffeeeedd__categories( $category_id, true, $sep );
			$home_url = get_page_link( get_option( 'page_for_posts' ) );
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title"><a href="' . esc_url( $home_url ) . '" itemprop="url">' . __( 'Entries', 'cdi-base-child' ) .'</a></span></div>' . $sep;
			/* Code modifié pour Asdel */
		} elseif ($category_id == 0) {
			$post_type = get_post_type();
			$tata = get_post_type_object( $post_type );
			$titrearchive = $tata->labels->menu_name;
			$urlarchive = get_post_type_archive_link( $post_type );
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( $urlarchive ) . '" title="' . esc_attr( $titrearchive ) . '" itemprop="url"><span itemprop="title">' . $titrearchive . '</span></a></div>';
		}

		// Avec des pages de commentaires
		$cpage = get_query_var( 'cpage' );
		
		if ( is_single() && $cpage > 0 ) {
			global $post;
			$permalink = get_permalink( $post->ID );
			$title = $post->post_title;
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( $permalink ) . '" itemprop="url" title="' . esc_attr( $title ) . '"><span itemprop="title">' . $title . '</span></a>' . $sep . '</div><div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( 'Comments page ', 'cdi-base-child' ) . $cpage . '</span></div>';
		}
		// Sans pages de commentaires
		else {
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . the_title( '', '', false ) . '</span></div>';
		}
	}
	// Catégories
	elseif ( is_category() ) {
		// Variables
		$categoryid = $GLOBALS['cat'];
		$category = get_category( $categoryid );
		$categoryparent = get_category( $category->parent );
		
		// Résultat
		if ( $category->parent != 0 ) {
			$final .=  '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . ffeeeedd__categories( $categoryparent, true, $sep, true ) . '</span></div>';
		}

		if ( $paged <= 1 ) {
			$final .=  '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . single_cat_title( '', false ) . '</span></div>';
		} else {
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="' . esc_url( get_category_link( $category ) ) . '" title="' . esc_attr( __( 'All entries in ', 'cdi-base-child' ) ) . esc_attr( single_cat_title( '', false ) ) . '" itemprop="url"><span itemprop="title">' . single_cat_title( '', false ) . '</span></a></div>';
		}
	}	
	// Pages
	elseif ( is_page() && !is_home() ) {
		$post = $wp_query->get_queried_object();
		
		// Page simple
		if ( $post->post_parent == 0 ) {
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . the_title( '', '', false ) . '</span></div>';
		}
		// Page avec ancêtre(s)
		elseif ( $post->post_parent != 0 ) {
			$title = the_title( '', '', false );
			$ancestors = array_reverse( get_post_ancestors( $post->ID ) );
			array_push( $ancestors, $post->ID );
			
			foreach ( $ancestors as $ancestor ) {
				if ( $ancestor != end( $ancestors ) ) {
					$name = strip_tags( apply_filters( 'single_post_title', get_the_title( $ancestor ) ) );
					$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a title="' . esc_attr( $name ) . '" href="' . esc_url( get_permalink( $ancestor ) ) . '" itemprop="url"><span itemprop="title">' . $name . '</span></a>' . $sep . '</div>';
				} else {
					$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . strip_tags( apply_filters( 'single_post_title', get_the_title( $ancestor ) ) ) . '</span></div>';
				}
			}
		}
	}
	// Auteurs
	elseif ( is_author() ) {
		if ( get_query_var( 'author_name' ) ) {
			$curauth = get_user_by( 'slug', get_query_var( 'author_name' ) );
		} else {
			$curauth = get_userdata( get_query_var( 'author' ) );
		}

		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( 'Entries written by ', 'cdi-base-child' ) . $curauth->nickname . '</span></div>';
	}
	// Tags
	elseif ( is_tag() ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( 'Entries about ', 'cdi-base-child' ) . single_tag_title( '', false ) . '</span></div>';
	}
	// Formats
	elseif ( is_tax( 'post_format' ) ) {
		$format = get_post_format( $post->ID );
		$pretty_format = get_post_format_string( $format );
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( 'Entries about ', 'cdi-base-child' ) . $pretty_format . '</span></div>';
	}
	// Taxonomies
	elseif ( is_tax( ) ) {
		$taxonomie = get_taxonomy( get_query_var( 'taxonomy' ) );
		$term = get_queried_object();
		$types = $taxonomie->object_type;
		$post_type = get_post_type_object( $types[0] );
		$parents = get_ancestors( $term->term_id, $taxonomie->name );
		
		// S’il y a une taxonomie parente, on la récupère aussi
		if ( is_taxonomy_hierarchical( $taxonomie->name ) && $term->parent != 0 ) {
			// On affiche le type d’articles
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a title="' . esc_attr( $post_type->labels->name ) . '" href="' . esc_url( get_post_type_archive_link( $post_type->name ) ) . '" itemprop="url"><span itemprop="title">' . $post_type->labels->name  . '</span></a>' . $sep . '</div>';
			// Puis la taxonomie de premier niveau
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a title="' . esc_attr( $taxonomie->labels->name ) . '" href="' . esc_url( get_term_link( $term->parent, $term->taxonomy ) ) . '" itemprop="url"><span itemprop="title">' . $taxonomie->labels->name  . '</span></a>' . $sep . '</div>';
			
			// Ensuite les taxonomies parentes intermédiaires
			foreach ( $parents as $parent_id ) {
				$parent = get_term_by( 'id', $parent_id, $taxonomie->name);

				if ( $parent->parent != 0 ) {
					$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a title="' . esc_attr( $parent->name ) . '" href="' . esc_url( get_term_link( $parent->term_id, $parent->taxonomy ) ) . '" itemprop="url"><span itemprop="title">' . $parent->name  . '</span></a>' . $sep . '</div>';
				}
			}
			// Et finalement le nom du terme affiché
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $term->name  . '</span></div>';
		} // Sinon, on affiche suelement le type et la taxonomie courante
		else {
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a title="' . esc_attr( $post_type->labels->name ) . '" href="' . esc_url( get_post_type_archive_link( $post_type->name ) ) . '" itemprop="url"><span itemprop="title">' . $post_type->labels->name  . '</span></a>' . $sep . '</div>';
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $term->name  . '</span></div>';
		}
	}
	// Recherche
	elseif ( is_search() ) {
		global $wp_query;
		$count = $wp_query->found_posts;

		if ( $count > 1 ) {
			$final .=  '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . sprintf( __('%1$s search results for %2$s', 'cdi-base-child' ), $count, get_search_query() ) . '</span></div>';
		} elseif ( $count == 1 ) {
			$final .=  '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . sprintf( __('A single search result for "%1$s"', 'cdi-base-child' ), get_search_query() ) . '</span></div>';
		}
	}
	// Page 404
	elseif ( is_404() ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( '404 - Page not found ', 'cdi-base-child' ) . '</span></div>';
	}
	// Types d’articles
	elseif ( is_post_type_archive() ) {
		$posttype = get_query_var('post_type');
		$posttypeobject = get_post_type_object( $posttype );
		$titrearchive = $posttypeobject->labels->menu_name;
		
		if ( isset( $titrearchive ) ) {
			$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . $titrearchive . '</span></div>';
		}
	}
	// Archives - autres
	elseif ( is_day() ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . sprintf( __( 'Archive : %s', 'cdi-base-child' ), get_the_date() ). '</span></div>';
	} elseif ( is_month() ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . sprintf( __( 'Archive : %s', 'cdi-base-child' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'cdi-base-child' ) ) ). '</span></div>';
	} elseif ( is_year() ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . sprintf( __( 'Archive : %s', 'cdi-base-child' ), get_the_date( _x( 'Y', 'yearly archives date format', 'cdi-base-child' ) ) ). '</span></div>';
	} elseif ( is_archive() ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><span itemprop="title">' . __( 'Archive', 'cdi-base-child' ) . '</span></div>';
	}

	// Pagination
	if ( $paged >= 1 ) {
		$final .= '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb">&nbsp;/&nbsp;<span itemprop="title">Page ' . $paged . '</span></div>';
	}
	
	// The End
	$final .= '</nav>';
	echo $final;
}