<?php
/**
 * Fonction pour ajouter des droits à des utilisateurs
 *
 * @author  Luc Poupard
 *
 * @link    https://codex.wordpress.org/Roles_and_Capabilities
 *          https://codex.wordpress.org/Function_Reference/add_cap
 *
 * @package CDI_Base_Child 2.1.0
 * @since   CDI_Base_Child 2.0.2
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
    == Ajout de droits par rôle
        -- Éditeur
        -- Auteur (Membre)
    == Ajout de droits par utilisateur
 */

function cdiwpchild_theme_caps() {
    /* == @section Ajout de droits par rôle ==================== */
    /* -- @subsection Éditeur -------------------- */
    $editor = get_role( 'editor' );

    /* On lui donne le droit d'éditer les options du thème */
    // $role->add_cap( 'edit_theme_options' );
    $editor->add_cap( 'list_users' );
    $editor->add_cap( 'create_users' );
    $editor->add_cap( 'edit_users' );

    $editor->add_cap( 'gravityforms_edit_forms' );
    $editor->add_cap( 'gravityforms_create_form' );

    $editor->add_cap( 'gravityforms_view_entries' );
    $editor->add_cap( 'gravityforms_edit_entries' );
    $editor->add_cap( 'gravityforms_delete_entries' );
    $editor->add_cap( 'gravityforms_export_entries' );
    $editor->add_cap( 'gravityforms_view_entry_notes' );
    $editor->add_cap( 'gravityforms_edit_entry_notes' );


    /* -- @subsection Auteur (Membre) -------------------- */
    /* On récupère le rôle Éditeur */
    $author = get_role( 'author' );

    /* On lui donne le droit d'éditer les options du thème */
    // $role->add_cap( 'edit_theme_options' );
    $author->remove_cap( 'edit_published_posts' );
    $author->remove_cap( 'publish_posts' );
    $author->remove_cap( 'delete_published_posts' );


    /* == @section Ajout de droits par utilisateur ==================== */
    /* On récupère l'utilisateur à partir de son ID */
    // $user = new WP_User( '1' );

    /* On lui donne le droit d'éditer les options du thème */
    // $user->add_cap( 'edit_theme_options' );
}
add_action( 'admin_init', 'cdiwpchild_theme_caps' );
