<?php
/**
 * Fichier pour afficher la page d'accueil
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.1
 */
get_header(); ?>
	<div id="site-content" class="site-content">
		<div class="home-events">
			<div class="carrousel">      
				<div class="carrousel__container"
				data-carrousel-btn-previous-text="Précédent"
				data-carrousel-btn-next-text="Suivant"
				data-carrousel-prefix-classes="event"
				data-carrousel-transition="slide"
				data-carrousel-existing-hx="h3">
					<?php
						/* On récupère la liste des actualités */
						$args_events = array(
							'post_type' => 'asdel_events',
							'nopaging' => false,
							'posts_per_page' => '5',
						);
						$loop_events = new WP_Query( $args_events );

						while ( $loop_events->have_posts() ) : $loop_events->the_post();

							$bg_event_full = get_the_post_thumbnail_url( get_the_ID(), 'full' );
							$bg_event_blog = get_the_post_thumbnail_url( get_the_ID(), 'event-thumb' );

							if ( $bg_event_blog ) {
								$bg_event = $bg_event_blog;
							} else {
								$bg_event = $bg_event_full;
							}
					?><!--

					--><div class="carrousel__content">
							<div class="carrousel__content-bg" style="background-image: url('<?php echo $bg_event; ?>');"></div>

							<div class="carrousel__content-text">
								<?php if( have_rows( 'evenement' ) ): ?>
									<div class="evenement">
										<?php while( have_rows( 'evenement' ) ): the_row();

											$event_intervenant	= get_sub_field( 'intervenant_bloc' );

											/*Date en français https://www.advancedcustomfields.com/resources/date-picker/ */
											$dateformatstring	= "j M Y";
											$unixtimestamp 		= strtotime( get_sub_field( 'date_bloc', false, false ) );

											$event_time 		= get_sub_field( 'heure_bloc' );
										?>

											<div class="carrousel__content-event__type"><?php the_sub_field( 'type_bloc' ); ?></div>
											
											<h2 class="carrousel__content-event__title"><?php the_title(); ?></h2>
											
											<div class="carrousel__content-event__speaker"><?php echo $event_intervenant; ?></div>
											
											<div class="carrousel__content-event__date"><?php echo date_i18n($dateformatstring, $unixtimestamp); ?></div>
											<?php if( $event_time ): ?>
												<div class="carrousel__content-event__time"><?php echo $event_time; ?></div>
											<?php endif; ?>
											<div class="carrousel__content-event__place"><?php the_sub_field( 'lieu_bloc' ); ?></div>
											
											<div class="carrousel__content-event__link">
												<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'En savoir plus', 'cdi-base-child'  ); ?></a>
											</div>

										<?php endwhile; ?>
									</div>
								<?php endif; ?>
							</div>
						</div><!--

					--><?php
						endwhile;
						wp_reset_postdata();
					?>
				</div>
			</div>
		</div>

		<main id="main" class="site-main" role="main">
			<?php
			/* Début de la boucle */
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/content', 'front' );

			endwhile;
			?>
			
			<hr>
			<div class="lesactusasdel">
				<div class="actus">
					<h2>Les actualités LIVRESUISSE</h2>

					<div class="carrousel">      
						<div class="carrousel__container"
						data-carrousel-btn-previous-text="Précédent"
						data-carrousel-btn-next-text="Suivant"
						data-carrousel-prefix-classes="news"
						data-carrousel-transition="slide"
						data-carrousel-existing-hx="h3">
							<?php
								/* On récupère la liste des actualités */
								$args_posts = array(
									'post_type' => 'asdel_news',
									'nopaging' => false,
									'posts_per_page' => '5',
								);
								$loop_posts = new WP_Query( $args_posts );

								while ( $loop_posts->have_posts() ) : $loop_posts->the_post();

									$bg_post_full = get_the_post_thumbnail_url( get_the_ID(), 'full' );
									$bg_post_blog = get_the_post_thumbnail_url( get_the_ID(), 'blog-thumb' );

									if ( $bg_post_blog ) {
										$bg_post = $bg_post_blog;
									} else {
										$bg_post = $bg_post_full;
									}
							?><!--

								--><div class="carrousel__content">
									<?php if ( $bg_post ) : ?>
										<div class="carrousel__content-bg" style="background-image: url('<?php echo $bg_post; ?>');"></div>
									<?php else : ?>
										<div class="carrousel__content-bg"></div>
									<?php endif; ?>

									<div class="carrousel__content-text">
										<h3><?php the_title(); ?></h3>

										<div class="carrousel__content-detail">
											<div class="carrousel__content-detail__meta">
												<span><?php echo get_the_date( 'd.m.Y' ); ?></span>
											</div>
											<div class="carrousel__content-detail__excerpt">
												<?php the_excerpt(); ?>

												<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Lire la suite', 'cdi-base-child'  ); ?></a>
											</div>
										</div>
									</div>
								</div><!--

							--><?php
								endwhile;
								wp_reset_postdata();
							?>
						</div>
					</div><!-- .carrousel__container -->
				</div><!-- .carrousel relative -->
			</div><!-- .lesactusasdel -->
		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
