<?php
/**
 * Pied de page
 *
 * C'est le template qui affiche la fermeture du contenu <div id="content">
 * et tout ce qui suit.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */

get_template_part( 'template-parts/footer', 'common' );


// Si un bloc contient un détail
// 1. On affiche le code pour l'afficher dans une modale
while ( have_posts() ) : the_post();
	if( have_rows( 'bloc_texte' ) ): $i = 0;
		while( have_rows( 'bloc_texte' ) ): the_row(); $i++; 
		$titre_bloc = get_sub_field( 'titre_bloc' );
		$detail_bloc = get_sub_field( 'texte_descriptif' ); ?>

<div class="dialog" aria-hidden="true" id="organisation-dialog-<?php echo $i; ?>">
	<div class="dialog-overlay" tabindex="-1" data-a11y-dialog-hide></div>
	<div class="dialog-content" aria-labelledby="organisation-dialog-title-<?php echo $i; ?>" aria-describedby="dialogDescription" role="dialog">
		<div role="document">
			<button data-a11y-dialog-hide class="dialog-close" aria-label="<?php echo __( 'Fermer le détail', 'cdi-base-child' ) ?>">&times;</button>

			<h1 id="organisation-dialog-title-<?php echo $i; ?>"><?php echo $titre_bloc; ?></h1>

			<?php echo $detail_bloc; ?>
		</div>
	</div>
</div>

		<?php endwhile;
	endif;
endwhile;

// 2. On affiche le code du footer (JS, etc)
wp_footer();

// 3. On ajoute le script pour activer la modale
while ( have_posts() ) : the_post();
	if( have_rows( 'bloc_texte' ) ): $i = 0; ?>

<script type="text/javascript">
<?php while( have_rows( 'bloc_texte' ) ): the_row(); $i++; ?>

	(function () {
		document.addEventListener('DOMContentLoaded', function () {
			var dialogEl_<?php echo $i; ?> = document.getElementById('organisation-dialog-<?php echo $i; ?>');
			var mainEl_<?php echo $i; ?> = document.getElementById('site-top');
			var dialog_<?php echo $i; ?> = new window.A11yDialog(dialogEl_<?php echo $i; ?>, mainEl_<?php echo $i; ?>);
		});
	}());

<?php endwhile; ?>
</script>

	<?php endif;
endwhile; ?>
</body>
</html>
