<?php
/**
 * Pied de page
 *
 * C'est le template qui affiche la fermeture du contenu <div id="content">
 * et tout ce qui suit.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */

get_template_part( 'template-parts/footer', 'common' );

// Affichage des modales de détail des membres
$members_args = array(
	'post_type' => 'asdel_members',
	'nopaging' => false,
	'posts_per_page' => '15',
	'orderby' => 'title',
	'order' => 'ASC',
	'paged' => $paged
);

$members_args['meta_query'] = array();

$members_args['meta_query'][] = array(
	'key' => 'bloc_membre_%_domaine_bloc',
	'value' => 'Librairies',
	'compare' => '=',
);

if( isset( $_GET['canton'] ) ) :
	$members_args['meta_query'][] = array(
		'key' => 'bloc_membre_%_canton_bloc',
		'value' => $_GET['canton'],
		'compare' => '=',
	);
endif;

$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$members_loop = new WP_Query( $members_args );

// Si un bloc contient un détail
// 1. On affiche le code pour l'afficher dans une modale
if ( $members_loop->have_posts() ) :
	while ( $members_loop->have_posts() ) : $members_loop->the_post();
		if( have_rows( 'bloc_membre' ) ): $i = 0;
			while( have_rows( 'bloc_membre' ) ): the_row(); $i++;
				$detail_bloc = get_sub_field( 'detail_bloc' );
				if( $detail_bloc ): ?>

	<div class="dialog" aria-hidden="true" id="membre-dialog-<?php echo $i; ?>">
		<div class="dialog-overlay" tabindex="-1" data-a11y-dialog-hide></div>
		<div class="dialog-content" aria-labelledby="membre-dialog-title-<?php echo $i; ?>" aria-describedby="dialogDescription" role="dialog">
			<div role="document">
				<button data-a11y-dialog-hide class="dialog-close" aria-label="<?php echo __( 'Fermer le détail', 'cdi-base-child' ) ?>">&times;</button>

				<h1 id="membre-dialog-title-<?php echo $i; ?>"><?php the_title(); ?></h1>

				<?php echo $detail_bloc; ?>
			</div>
		</div>
	</div>

				<?php endif;
			endwhile;
		endif;
	endwhile;

	// Code du footer (JS, etc)
	wp_footer(); ?>

	<script type="text/javascript">
		<?php
		// Script pour activer les modales de détail des membres
		while ( $members_loop->have_posts() ) : $members_loop->the_post();
			if( have_rows( 'bloc_membre' ) ): $i = 0;
				while( have_rows( 'bloc_membre' ) ): the_row(); $i++;
					$detail_bloc = get_sub_field( 'detail_bloc' );
					if( $detail_bloc ): ?>

		(function () {
			document.addEventListener('DOMContentLoaded', function () {
				var dialogEl_<?php echo $i; ?> = document.getElementById('membre-dialog-<?php echo $i; ?>');
				var mainEl_<?php echo $i; ?> = document.getElementById('site-top');
				var dialog_<?php echo $i; ?> = new window.A11yDialog(dialogEl_<?php echo $i; ?>, mainEl_<?php echo $i; ?>);
			});
		}());

				<?php endif;
				endwhile;
			endif;
		endwhile; ?>
	</script>
<?php
// Au cas-où
else:
	// Code du footer (JS, etc)
	wp_footer();
endif;

if( isset( $_GET['canton'] ) ) :
	$filtre_actif = $_GET['canton'];
endif; ?>

<script type="text/javascript">
	(function($) {
		// On ajoute disabled sur l'option - Choisir -
		$('.filtre-membre option').filter(function() {
			return !this.value || $.trim(this.value).length == 0;
		})
		.prop('disabled', true);

		<?php if( isset( $_GET['canton'] ) ) : ?>
			$('.filtre-membre select').val('<?php echo $filtre_actif; ?>');
		<?php endif; ?>
		
		// change
		$('.filtre-membre').on('change', 'select', function(){
			// vars
			var url = '<?php echo home_url('membres/libraires/'); ?>';
				args = {};

			// loop over filters
			$('.filtre-membre').each(function(){
				// vars
				var filter = $(this).data('filter'),
					vals = [];

				// find checked inputs
				$(this).find('option:selected').each(function(){
					vals.push( $(this).val() );
				});

				// append to args
				args[ filter ] = vals.join(',');
			});

			// update url
			url += '?';

			// loop over args
			$.each(args, function( name, value ){
				url += 'canton=' + value + '&';
			});

			// remove last &
			url = url.slice(0, -1);

			// reload page
			window.location.replace( url );
		});
	})(jQuery);
</script>
</body>
</html>