<?php
/**
 * Template Name: Bloc texte
 *
 * Fichier pour afficher les pages
 *
 * @author  Luc Poupard
 *
 * @note    Inspiré d'un tutoriel :
 * @author  Rémi Corson
 * @link    http://www.remicorson.com/create-a-simple-wordpress-sitemap/
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
get_header(); ?>


<div id="site-content" class="site-content">
        <main id="main" class="site-main" role="main">
            <h1><?php the_title() ?></h1>

            <?php
            /* Début de la boucle */
            while ( have_posts() ) : the_post(); ?>
            
                <div class="wrapper-content">
                    <?php the_content();?>  
                    
                    <div class="bloc_texte">

                        <?php if( have_rows( 'bloc_texte' ) ): $i = 0; ?>
                            <div class="list">
                                <?php while( have_rows( 'bloc_texte' ) ): the_row(); $i++; 
                                    $titre_bloc = get_sub_field( 'titre_bloc' );
                                    $texte_bloc = get_sub_field( 'texte_bloc' );
                                    $detail_bloc = get_sub_field( 'texte_descriptif' );
                                ?>

                                    <div class="bloctexte">
                                        <?php if( $titre_bloc ): ?>
                                            <h2><?php echo $titre_bloc; ?></h2>
                                        <?php endif; ?>

                                        <div class="texte_bloc">
                                            <?php echo $texte_bloc; ?>
                                        </div>

                                        <?php if( $detail_bloc ): ?>
                                            <button type="button" data-a11y-dialog-show="organisation-dialog-<?php echo $i; ?>">
                                                <?php echo __( 'Détail', 'cdi-base-child' ) ?>
                                            </button>
                                        <?php endif; ?>
                                    </div>

                                <?php endwhile; ?>
                            </div>
                        <?php endif; ?>

                    </div>
                </div><!-- .entry-content -->
                
            <?php endwhile; ?>
        </main><!-- #main -->
    </div><!-- #site-content -->

<?php
get_sidebar();
get_footer();

