<?php
/**
 * Template part for displaying single posts.
 *
 * @link 		https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	Aoxy_1.0.1
 * @since 		1.0.0
 */

?>

<article id="tour-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="tour-content">
		<div class="tour-thumbnail">
			<?php the_post_thumbnail(); ?>
		</div>
		
		<div>
			<h2>Description</h2>
			<?php the_content(); ?>
			
			<?php
			/* Si le champ Galerie photo contient du contenu, on affiche la galerie*/
			$is_galerie = get_field( 'galerie_photo' ); 
			if( $is_galerie ) {
			?>
				<h2>La randonnée en image</h2>
				<div><?php the_field( 'galerie_photo' ); ?></div>
			<?php } ?>
		</div>

		<div>
			<h2 id="form-reservation">Réservation ou demande d'information</h2>
			<?php
			// Dev
			// echo do_shortcode( '[contact-form-7 id="1480"]' );
			
			// Prod
			echo do_shortcode( '[contact-form-7 id="2468"]' );
			?>
		</div>
	</div><!-- .entry-content -->

	<div class="tour-sidebar">
		<footer class="tour-footer">
			<h2>Informations</h2>
			<?php
				/* On définit une variable avec le contenu du chaque champs ACF */
				$is_saisons			= get_field( 'info_saisons' );
				$is_duree			= get_field( 'info_duree' );
				$is_denivele		= get_field( 'info_denivele' );
				$is_distance		= get_field( 'info_distance' );
				$is_niveaux			= get_field( 'info_niveaux' );
				$is_regions			= get_field( 'info_regions' );
				$is_accompagnateurs	= get_field( 'info_accompagnateurs' );
			?>

			<ul>
				<?php
				/* Si le champ info_saison contient une valeur, on l'affiche */
				if( $is_saisons ) { ?>
					<li><span>Saisons</span> <?php the_field( 'info_saisons' ); ?></li>
				<?php } else { ?>
					<li><span>Saisons</span> <?php the_field( 'saisons' ); ?></li>
				<?php }

				/* Si le champ info_duree contient une valeur, on l'affiche */
				if( $is_duree ) { ?>
					<li><span>Durée</span> <?php the_field( 'info_duree' ); ?></li>
				<?php }

				/* Si le champ info_denivele contient une valeur, on l'affiche */
				if( $is_denivele ) { ?>
					<li><span>Dénivelé</span> <?php the_field( 'info_denivele' ); ?></li>
				<?php }

				/* Si le champ info_distance contient une valeur, on l'affiche */
				if( $is_distance ) { ?>
					<li><span>Distance</span> <?php the_field( 'info_distance' ); ?></li>
				<?php }

				/* Si le champ info_niveau contient une valeur, on l'affiche */
				if( $is_niveaux ) { ?>
					<li><span>Niveau</span> <?php the_field( 'info_niveaux' ); ?></li>
				<?php } else { ?>
					<li><span>Niveaux</span> <?php the_field( 'niveaux' ); ?></li>
				<?php }

				/* Si le champ info_situation contient une valeur, on l'affiche */
				if( $is_regions ) { ?>
					<li><span>Situation</span> <?php the_field( 'info_regions' ); ?></li>
				<?php } else { ?>
					<li><span>Situation</span> <?php the_field( 'regions' ); ?></li>
				<?php }

				/* Si le champ info_accompagnateurs contient une valeur, on l'affiche */
				if( $is_accompagnateurs ) { ?>
					<li><span>Avec</span> <a href="/?page_id=34"><?php the_field( 'info_accompagnateurs' ); ?></a></li>
				<?php } else { ?>
					<li><span>Avec</span> <a href="/?page_id=34"><?php the_field( 'accompagnateurs' ); ?></a></li>
				<?php } ?>
			</ul>
		</footer><!-- .entry-footer -->


		<div class="tour-contact">
			<p>Réservation ou demande d'information</p>
			<a href="#form-reservation" class="button">Contactez-nous</a>
		</div>
	</div>

	<div class="clear"></div>
</article><!-- #post-## -->