<?php
/**
 * Template part for displaying single posts.
 *
 * @link 		https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	Aoxy_1.0.1
 * @since 		1.0.0
 */

?>

<article id="presse-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="presse-primary">
		<h2>Vidéos</h2>

		<?php $loop = new WP_Query( array(
			'post_type' => 'videos',
			'nopaging' => true
		) );
		if ( $loop->have_posts() ) : 
			while ( $loop->have_posts() ) : $loop->the_post();

				$video = get_field( 'video_interne' );
				$video_url = $video['url'];
				if ( $video ): ?>

					<?php echo do_shortcode( '[video src="' . $video_url . '"]' ); ?>

				<?php endif;
			endwhile;
		endif;
		wp_reset_postdata(); ?>


		<!-- <h2>Vidéos externes</h2> -->

		<?php $loop_tiers = new WP_Query( array(
			'post_type' => 'videos',
			'nopaging' => true
		) );
		if ( $loop_tiers->have_posts() ) : 
			while ( $loop_tiers->have_posts() ) : $loop_tiers->the_post();

				$video_externe = get_field( 'video_externe' );
				if ( $video_externe ): ?>

					<div class="embed-container">
						<?php echo $video_externe; ?>
					</div>

			<?php endif; endwhile;

		endif;
		wp_reset_postdata(); ?>


		<?php if( have_rows( 'presse_citations' ) ): ?>

			<h2>Témoignages</h2>

			<?php while( have_rows( 'presse_citations' ) ): the_row();
				$citation_auteur = get_sub_field( 'presse_citations_auteur' );
				$citation_texte = get_sub_field( 'presse_citations_message' );
			?>

				<blockquote>
					<?php echo $citation_texte; ?>
					
					<footer><?php echo $citation_auteur; ?></footer>
				</blockquote>

			<?php endwhile; ?>

		<?php endif; ?>
	</div><!-- .presse-primary -->

	<div class="presse-secondary">
		<?php if( have_rows( 'presse_documents' ) ): ?>

			<h2>Documents</h2>

			<ul>

			<?php while( have_rows( 'presse_documents' ) ): the_row();
				$doc_fichier = get_sub_field( 'presse_documents_fichier' );
			?>

				<li>
					<a href="<?php echo $doc_fichier['url']; ?>"><?php echo $doc_fichier['title']; ?></a>
				</li>

			<?php endwhile; ?>

			</ul>

		<?php endif; ?>


		<?php if( have_rows( 'presse_liens' ) ): ?>

			<h2>Liens</h2>

			<ul>

			<?php while( have_rows( 'presse_liens' ) ): the_row();
				$lien_label = get_sub_field( 'revue_liens_label' );
				$lien_url = get_sub_field( 'revue_liens_url' );
			?>

				<li>
					<a href="<?php echo $lien_url; ?>"><?php echo $lien_label; ?></a>
				</li>

			<?php endwhile; ?>

			</ul>

		<?php endif; ?>
	</div><!-- .presse-secondary -->

	<div class="clear"></div>
</article><!-- #post-## -->