<?php
/**
 * Template Name: Randonnées
 *
 * The template for displaying Tour pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link 		https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	Aoxy_1.2.0
 * @since 		1.0.0
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="tour-filters clearfix">
				<div class="clearfix"><span>Choisissez la/les saisons&nbsp;:</span>
					<div><input type="checkbox" name="printemps" value=".printemps" id="printemps">
					<label for="printemps" class="sprite sprite-saison-printemps">Printemps</label></div>

					<div><input type="checkbox" name="ete" value=".ete" id="ete">
					<label for="ete" class="sprite sprite-saison-ete">Été</label></div>

					<div><input type="checkbox" name="automne" value=".automne" id="automne">
					<label for="automne" class="sprite sprite-saison-automne">Automne</label></div>

					<div><input type="checkbox" name="hiver" value=".hiver" id="hiver">
					<label for="hiver" class="sprite sprite-saison-hiver">Hiver</label></div>
				</div>

				<div><span>Trier par situation géographique&nbsp;:</span>
					<?php
					// regions : field_5645bde45070e 
					$field_key = "field_5645bde45070e";
					$field = get_field_object($field_key);

					if( $field ) {
						echo '<select name="' . $field['key'] . '">';
						echo '<option value="">Toutes les régions</option>';
							foreach( $field['choices'] as $k => $v ) {
								echo '<option value=".' . $k . '">' . $v . '</option>';
							}
						echo '</select>';
					}
					?>
				</div>
			</div>

			<div class="tour-alacarte">
				<p>Vous ne trouvez pas de course adaptée à vos besoins ?<br />
				<a href="/?page_id=30">Créez votre randonnée à la carte</a></p>
			</div>

			<div class="tour-list clear">
				<?php
				/* On récupère la liste des randonnées*/
				$args = array( 'post_type' => 'tour' );
				$loop = new WP_Query( $args );

				while ( $loop->have_posts() ) : $loop->the_post(); ?>
					<?php
						$saisons	= get_field( 'saisons' );
						$niveaux	= get_field( 'niveaux' );

						// Class CSS sur <article> pour les filtres
						// Formatage : http://support.advancedcustomfields.com/forums/topic/cpt-archive-need-custom-field-values-as-classes-for-each-post/
						$saisonsclass 	= get_field( 'saisons' );
						$saisonsclass 	= array_map('sanitize_title', $saisonsclass);
						$saisonsclass 	= implode(' ', $saisonsclass );
						$regions 	= get_field( 'regions' );
						$regions 	= array_map('sanitize_title', $regions);
						$regions 	= implode(' ', $regions );
					?>
					<article class="tour-item clearfix <?php echo $saisonsclass; ?> <?php echo $regions; ?>">
						<a href="<?php the_permalink() ?>" aria-hidden="true" tabindex="-1" role="presentation"><?php the_post_thumbnail(); ?></a>

						<div>
							<h2><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>

							<div class="extrait"><?php the_excerpt() ?></div>

							<div class="caracteristiques-info">
								<div>
									<?php if( in_array( 'Facile', $niveaux ) ) { ?>
										<span class="sprite sprite-niveau-facile" title="Facile">Facile</span>
									<?php } else { ?>
										<span class="sprite sprite-asterisk"></span>
									<?php } ?>

									<?php if( in_array( 'Moyen', $niveaux ) ) { ?>
										<span class="sprite sprite-niveau-moyen" title="Moyen">Moyen</span>
									<?php } else { ?>
										<span class="sprite sprite-asterisk"></span>
									<?php } ?>

									<?php if( in_array( 'Averti', $niveaux ) ) { ?>
										<span class="sprite sprite-niveau-averti" title="Averti">Averti</span>
									<?php } else { ?>
										<span class="sprite sprite-asterisk"></span>
									<?php } ?>

									<?php if( in_array( 'Expert', $niveaux ) ) { ?>
										<span class="sprite sprite-niveau-expert" title="Expert">Expert</span>
									<?php } else { ?>
										<span class="sprite sprite-asterisk"></span>
									<?php } ?>

									<span>|</span>

									<?php if( in_array( 'Printemps', $saisons ) ) { ?>
										<span class="sprite sprite-saison-printemps" title="Printemps">Printemps</span>
									<?php } else { ?>
										<span class="sprite sprite-feuille"></span>
									<?php } ?>

									<?php if( in_array( 'Été', $saisons ) ) { ?>
										<span class="sprite sprite-saison-ete" title="Été">Été</span>
									<?php } else { ?>
										<span class="sprite sprite-feuille"></span>
									<?php } ?>

									<?php if( in_array( 'Automne', $saisons ) ) { ?>
										<span class="sprite sprite-saison-automne" title="Automne">Automne</span>
									<?php } else { ?>
										<span class="sprite sprite-feuille"></span>
									<?php } ?>

									<?php if( in_array( 'Hiver', $saisons ) ) { ?>
										<span class="sprite sprite-saison-hiver" title="Hiver">Hiver</span>
									<?php } else { ?>
										<span class="sprite sprite-feuille"></span>
									<?php } ?>
								</div>

								<div><a href="<?php the_permalink() ?>" class="button">+ Information</a></div>
							</div>
						</div>
					</article>
				<?php endwhile; ?>
			</div>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_footer(); ?>
