// http://stackoverflow.com/questions/12343714/typeerror-is-not-a-function-when-calling-jquery-function
jQuery(function ($) {
	// https://github.com/metafizzy/isotope/issues/771
	var $container = $('.tour-list').isotope({
		itemSelector: '.tour-item'
	});

	// filter with selects and checkboxes
	var $selects = $('.tour-filters select');
	var $checkboxes = $('.tour-filters input');

	$selects.add( $checkboxes ).change( function() {
		// map input values to an array
		var exclusives = [];
		var inclusives = [];
		// exclusive filters from selects
		$selects.each( function( i, elem ) {
			if ( elem.value ) {
				exclusives.push( elem.value );
			}
		});
		// inclusive filters from checkboxes
		$checkboxes.each( function( i, elem ) {
			// if checkbox, use value if checked
			if ( elem.checked ) {
				inclusives.push( elem.value );
			}
		});

		// combine exclusive and inclusive filters

		// first combine exclusives
		exclusives = exclusives.join('');

		var filterValue;
		if ( inclusives.length ) {
			// map inclusives with exclusives for
			filterValue = $.map( inclusives, function( value ) {
				return value + exclusives;
			});
			filterValue = filterValue.join(', ');
		} else {
			filterValue = exclusives;
		}

		$container.isotope({ filter: filterValue })
	});
});