<?php
/**
 * Fonctions du thème
 *
 * @link 		https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author 		Luc Poupard
 *
 * @package 	Aoxy_2.1.0
 * @since		Aoxy_1.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Fonctions WordPress
		-- Traductions
		-- Menus de navigation
		-- Images à la Une
		-- Flux RSS
	== Widgets
	== Ajout des styles du thème
	== Fonctions externalisées
		-- Global
		-- Front
		-- Administration
	== Fonctions Aoxy
		-- Nettoyage de l'entête
		-- CPT Randonnée
		-- Résultats de recherche
		-- Filtres randonnées
*/


/* == @section Fonctions WordPress ==================== */
function aoxy_setup() {
	/* -- @subsection Traductions -------------------- */
	/**
	 * Préparer le thème pour traduction.
	 * Les traductions sont placées dans le répertoire /languages/
	 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdi-base-child' )
	 */
	load_child_theme_textdomain( 'aoxy', get_stylesheet_directory() . '/languages' );


	/* -- @subsection Menus de navigation -------------------- */
	/**
	 * Déclaration du menu de navigation principal.
	 */
	// register_nav_menus( array(
	// 	'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
	// ) );


	/* -- @subsection Images à la Une -------------------- */
	/**
	 * On supprime le support des Images à la Une par défaut
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'post-thumbnails' );

	/* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
	// set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


	/* -- @subsection Flux RSS -------------------- */
	/**
	 * On supprime le support les adresses de flux dans <head>
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'automatic-feed-links' );	
}
add_action( 'after_setup_theme', 'aoxy_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
// function remove_cdiwpchild_widgets() {
// 	unregister_sidebar( 'sidebar-1' );
// }
// add_action( 'widgets_init', 'remove_cdiwpchild_widgets' );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */


/* == @section Ajout des styles du thème ==================== */
function aoxy_styles() {
	wp_register_style(
		'satisfy',
		'https://fonts.googleapis.com/css?family=Satisfy',
		false,
		null,
		'all'
	);

	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		null,
		'all'
	);

	// Carrousel sur la page d'accueil
	wp_register_script(
		'carrousel',
		get_stylesheet_directory_uri() . '/js/jquery-accessible-carrousel-aria.min.js',
		false,
		null,
		true
	);

	// Filtres sur la liste des randonnées
	wp_register_script(
		'isotope',
		get_stylesheet_directory_uri() . '/js/isotope.pkgd.min.js',
		false,
		null,
		true
	);
	wp_register_script(
		'isotope-init',
		get_stylesheet_directory_uri() . '/js/isotope.init.js',
		false,
		null,
		true
	);

	wp_register_script(
		'menu-mobile',
		get_stylesheet_directory_uri() . '/js/navigation.js',
		false,
		null,
		true
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'satisfy' );
	wp_enqueue_style( 'all' );
	wp_enqueue_script( 'carrousel' );
	wp_enqueue_script( 'isotope' );
	wp_enqueue_script( 'isotope-init' );
	wp_enqueue_script( 'menu-mobile' );
}
add_action( 'wp_enqueue_scripts', 'aoxy_styles' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

	/* Ajouter des droits à des utilisateurs */
	require get_stylesheet_directory() . '/functions/admin_capabilities.php';

	/* Cacher des items du menu aux non administrateurs */
	require get_stylesheet_directory() . '/functions/admin_menu.php';

	/* Cacher les widgets du dashboard */
	// require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}


/* == @section Fonctions Aoxy ==================== */
/* -- @subsection Nettoyage de l'entête -------------------- */
/* Suppression des styles de plugins */
add_filter( 'wpcf7_load_css', '__return_false' );

function remove_em_css(){
	wp_deregister_style( 'events-manager' );
}
add_action( 'wp_enqueue_scripts', 'remove_em_css', 100 );


/* -- @subsection CPT Randonnée -------------------- */
function tour_post_type() {
	// Randonnées
	$labels = array(
		'name'                  => __( 'Tours', 'aoxy' ),
		'singular_name'         => __( 'Tour', 'aoxy' ),
		'menu_name'             => __( 'Tours', 'aoxy' ),
		'name_admin_bar'        => __( 'Tours', 'aoxy' ),
		'parent_item_colon'     => __( 'Parent Tour:', 'aoxy' ),
		'all_items'             => __( 'All Tours', 'aoxy' ),
		'add_new_item'          => __( 'Add New Tour', 'aoxy' ),
		'add_new'               => __( 'New Tour', 'aoxy' ),
		'new_item'              => __( 'New Tour', 'aoxy' ),
		'edit_item'             => __( 'Edit Tour', 'aoxy' ),
		'update_item'           => __( 'Update Tour', 'aoxy' ),
		'view_item'             => __( 'View Tour', 'aoxy' ),
		'search_items'          => __( 'Search tours', 'aoxy' ),
		'not_found'             => __( 'No tours found', 'aoxy' ),
		'not_found_in_trash'    => __( 'No tours found in Trash', 'aoxy' ),
		'items_list'            => __( 'Items list', 'aoxy' ),
		'items_list_navigation' => __( 'Items list navigation', 'aoxy' ),
		'filter_items_list'     => __( 'Filter items list', 'aoxy' ),
	);
	$args = array(
		'label'                 => __( 'Tour', 'aoxy' ),
		'description'           => __( 'Tour pages', 'aoxy' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions' ),
		//'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-location-alt',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'tour', $args );

	// Vidéos
	$labels = array(
		'name'                  => _x( 'Videos', 'Post Type General Name', 'aoxy' ),
		'singular_name'         => _x( 'Video', 'Post Type Singular Name', 'aoxy' ),
		'menu_name'             => __( 'Videos', 'aoxy' ),
		'name_admin_bar'        => __( 'Video', 'aoxy' ),
		'archives'              => __( 'Video Archives', 'aoxy' ),
		'attributes'            => __( 'Video Attributes', 'aoxy' ),
		'parent_item_colon'     => __( 'Parent Video:', 'aoxy' ),
		'all_items'             => __( 'All Videos', 'aoxy' ),
		'add_new_item'          => __( 'Add New Video', 'aoxy' ),
		'add_new'               => __( 'Add New', 'aoxy' ),
		'new_item'              => __( 'New Video', 'aoxy' ),
		'edit_item'             => __( 'Edit Video', 'aoxy' ),
		'update_item'           => __( 'Update Video', 'aoxy' ),
		'view_item'             => __( 'View Video', 'aoxy' ),
		'view_items'            => __( 'View Videos', 'aoxy' ),
		'search_items'          => __( 'Search Video', 'aoxy' ),
		'not_found'             => __( 'Not found', 'aoxy' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'aoxy' ),
		'featured_image'        => __( 'Featured Image', 'aoxy' ),
		'set_featured_image'    => __( 'Set featured image', 'aoxy' ),
		'remove_featured_image' => __( 'Remove featured image', 'aoxy' ),
		'use_featured_image'    => __( 'Use as featured image', 'aoxy' ),
		'insert_into_item'      => __( 'Insert into video', 'aoxy' ),
		'uploaded_to_this_item' => __( 'Uploaded to this video', 'aoxy' ),
		'items_list'            => __( 'Videos list', 'aoxy' ),
		'items_list_navigation' => __( 'Videos list navigation', 'aoxy' ),
		'filter_items_list'     => __( 'Filter videos list', 'aoxy' ),
	);
	$args = array(
		'label'                 => __( 'Video', 'aoxy' ),
		'description'           => __( 'Post Type Description', 'aoxy' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-video-alt3',
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'videos', $args );

}
add_action( 'init', 'tour_post_type', 0 );


/* -- @subsection Résultats de recherche -------------------- */
/* @author Éléonore Leibzig (06.12.13 in Trek theme) */
/* @note Les résultats de recherchent retournent les randonnées uniquement */
function searchfilter( $query ) {
	if ( $query->is_search && !is_admin() ) {
		$query->set( 'post_type', array( 'tour' ) );
	}
	return $query;
}
add_filter( 'pre_get_posts', 'searchfilter' );


/* -- @subsection Filtres randonnées -------------------- */

/* Filtrage des randonnées avec Isotope
 * @link http://isotope.metafizzy.co/
 *
 * Filtres multiples avec checkboxes
 * 	http://stackoverflow.com/questions/17553076/isotope-combination-filtering-multiple-selection
 *	http://jsfiddle.net/GwBa8/363/
 *
 * Filtre avec liste déroulante
 *  https://github.com/metafizzy/isotope/issues/771
 *  http://codepen.io/desandro/pen/draxo
 */