<?php
/**
 * The template for displaying the front page.
 *
 * @link 		https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	Aoxy_1.2.1
 * @since 		1.0.0
 */

get_header(); ?>
		
	<main id="main" class="site-main" role="main">

		<div class="introduction">
			<div class="content-area clearfix">
				<h2>Accompagnement en montagne</h2>

				<p>Pour votre plaisir, nous organisons vos sorties, particuliers ou entreprises, tout en veillant sur votre sécurité.</p>

				<div>
					<a class="button" href="/?page_id=27">Voir nos randonnées</a>
				</div>
			</div>
		</div>

		<div class="arguments">
			<div class="content-area clearfix">
				<div>
					<img src="<?php echo get_stylesheet_directory_uri() . '/img/home-racines.png'; ?>" width="63" height="60" alt="" />
					<h3>Renouer avec ses racines</h3>
					<p>Attitude Oxygen a pour devise d'offrir du rêve. Laissez-vous conter et venez découvrir les mystères de nos montagnes.</p>
	 			</div>

				<div>
					<img src="<?php echo get_stylesheet_directory_uri() . '/img/home-excursions.png'; ?>" width="63" height="60" alt="" />
					<h3>Excursions à la carte</h3>
					<p>Nous créons des excursions au gré de vos envies et désirs.</p>
	 			</div>

				<div>
					<img src="<?php echo get_stylesheet_directory_uri() . '/img/home-groupe.png'; ?>" width="63" height="60" alt="" />
					<h3>En solo ou en groupe</h3>
					<p>À votre niveau, nous nous adaptons pour passer des moments surprenants et inoubliables.</p>
	 			</div>

				<div>
					<img src="<?php echo get_stylesheet_directory_uri() . '/img/home-jours.png'; ?>" width="78" height="60" alt="" />
					<h3>Un ou plusieurs jours</h3>
					<p>À la découverte d'une nature belle et sauvage, venez réaliser un de vos rêves les plus fous.</p>
	 			</div>
			</div>
		</div>


		<?php
			/* On récupère les 3 premières randonnées (post_per_page) mises en avant */
			$carrousel = new WP_Query(
				array(
					'post_type' 		=> 'tour',
					'posts_per_page' 	=> 3,
					'meta_key'			=> 'affichage_home',
					'meta_value'		=> 1
				)
			);
			/* On récupère les randonnées 4 à 6 (post_per_page + offset) mises en avant */
			$carrousel2 = new WP_Query(
				array(
					'post_type' 		=> 'tour',
					'posts_per_page' 	=> 3,
					'meta_key'			=> 'affichage_home',
					'meta_value'		=> 1,
					'offset' 			=> 3 // Affiche à partir du 4ème résultat
				)
			);
			/* On récupère les randonnées 7 à 9 (post_per_page + offset) mises en avant */
			$carrousel3 = new WP_Query(
				array(
					'post_type' 		=> 'tour',
					'posts_per_page' 	=> 3,
					'meta_key'			=> 'affichage_home',
					'meta_value'		=> 1,
					'offset' 			=> 6 // Affiche à partir du 7ème résultat
				)
			);

			/* On teste si on a un résultat dans la première boucle
			 * Si on n'a pas de résultat dans la première, il n'y en aura de toute façon pas dans les suivantes
			 */
			if ( $carrousel->have_posts() ) :
		?>

	 		<div class="randonnees">
				<div class="content-area">
					<hr />

					<h2>Randonnées actuelles</h2>

					<div class="carrousel relative">      
						<div class="carrousel__container mod--hidden" 
						data-carrousel-btn-previous-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-left.png'; ?>" 
						data-carrousel-btn-next-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-right.png'; ?>"
						data-carrousel-btn-previous-text="Précédent"
						data-carrousel-btn-next-text="Suivant"
						data-carrousel-prefix-classes="tour"
						data-carrousel-span-text-class="visually-hidden"
						data-carrousel-transition="slide"
						data-carrousel-existing-hx="hx">
							<?php if ( $carrousel->have_posts() ) : ?>
								<div class="carrousel__content">
									<?php while ( $carrousel->have_posts() ) : $carrousel->the_post(); ?>
										<div class="carrousel-item">
											<div class="thumbnail">
												<a href="<?php the_permalink() ?>" tabindex="-1"><?php the_post_thumbnail(); ?></a>
											</div>
											
											<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
											
											<div class="extrait"><?php the_excerpt() ?></div>
											
											<?php
												$saisons	= get_field( 'saisons' );
												$niveaux	= get_field( 'niveaux' );
											?>
											<div class="infos">
												<?php if( in_array( 'Facile', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-facile" title="Facile">Facile</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Moyen', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-moyen" title="Moyen">Moyen</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Averti', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-averti" title="Averti">Averti</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Expert', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-expert" title="Expert">Expert</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<span>|</span>

												<?php if( in_array( 'Printemps', $saisons ) ) { ?>
													<span class="sprite sprite-saison-printemps" title="Printemps">Printemps</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Été', $saisons ) ) { ?>
													<span class="sprite sprite-saison-ete" title="Été">Été</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Automne', $saisons ) ) { ?>
													<span class="sprite sprite-saison-automne" title="Automne">Automne</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Hiver', $saisons ) ) { ?>
													<span class="sprite sprite-saison-hiver" title="Hiver">Hiver</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							<?php
								endif; 

								if
								/* On teste s'il y a 4+ randonnées mises en avant */
								( $carrousel2->have_posts() ) :
							?>
								<div class="carrousel__content">
									<?php while ( $carrousel2->have_posts() ) : $carrousel2->the_post(); ?>
										<div class="carrousel-item">
											<div class="thumbnail">
												<?php the_post_thumbnail(); ?>
											</div>
										
											<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
											
											<div class="extrait"><?php the_excerpt() ?></div>
											
											<?php
												$saisons	= get_field( 'saisons' );
												$niveaux	= get_field( 'niveaux' );
											?>
											<div class="infos">
												<?php if( in_array( 'Facile', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-facile" title="Facile">Facile</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Moyen', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-moyen" title="Moyen">Moyen</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Averti', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-averti" title="Averti">Averti</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Expert', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-expert" title="Expert">Expert</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<span>|</span>

												<?php if( in_array( 'Printemps', $saisons ) ) { ?>
													<span class="sprite sprite-saison-printemps" title="Printemps">Printemps</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Été', $saisons ) ) { ?>
													<span class="sprite sprite-saison-ete" title="Été">Été</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Automne', $saisons ) ) { ?>
													<span class="sprite sprite-saison-automne" title="Automne">Automne</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Hiver', $saisons ) ) { ?>
													<span class="sprite sprite-saison-hiver" title="Hiver">Hiver</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							<?php
								endif;

								/* On teste s'il y a 7+ randonnées mises en avant */
								if ( $carrousel3->have_posts() ) :
							?>
								<div class="carrousel__content">
									<?php while ( $carrousel3->have_posts() ) : $carrousel3->the_post(); ?>
										<div class="carrousel-item">
											<div class="thumbnail">
												<?php the_post_thumbnail(); ?>
											</div>
											
											<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
											
											<div class="extrait"><?php the_excerpt() ?></div>
											
											<?php
												$saisons	= get_field( 'saisons' );
												$niveaux	= get_field( 'niveaux' );
											?>
											<div class="infos">
												<?php if( in_array( 'Facile', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-facile" title="Facile">Facile</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Moyen', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-moyen" title="Moyen">Moyen</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Averti', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-averti" title="Averti">Averti</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<?php if( in_array( 'Expert', $niveaux ) ) { ?>
													<span class="sprite sprite-niveau-expert" title="Expert">Expert</span>
												<?php } else { ?>
													<span class="sprite sprite-asterisk"></span>
												<?php } ?>

												<span>|</span>

												<?php if( in_array( 'Printemps', $saisons ) ) { ?>
													<span class="sprite sprite-saison-printemps" title="Printemps">Printemps</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Été', $saisons ) ) { ?>
													<span class="sprite sprite-saison-ete" title="Été">Été</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Automne', $saisons ) ) { ?>
													<span class="sprite sprite-saison-automne" title="Automne">Automne</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>

												<?php if( in_array( 'Hiver', $saisons ) ) { ?>
													<span class="sprite sprite-saison-hiver" title="Hiver">Hiver</span>
												<?php } else { ?>
													<span class="sprite sprite-feuille"></span>
												<?php } ?>
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>

		<div class="home-video">
			<div class="content-area">
				<hr />

				<?php while ( have_posts() ) : the_post();
					$posts = get_field('home_video');
						if( $posts ):
							foreach( $posts as $post):
								setup_postdata($post); ?>

								<h2><?php the_title(); ?></h2>

								<div class="home-video__content">
									<div>
										<?php $video = get_field( 'video_interne' );
										$video_url = $video['url'];
										if ( $video ): ?>

											<?php echo do_shortcode( '[video src="' . $video_url . '"]' ); ?>

										<?php endif; ?>
										
										<?php $video_externe = get_field( 'video_externe' );
										if ( $video_externe ): ?>

											<div class="embed-container">
												<?php echo $video_externe; ?>
											</div>

										<?php endif; ?>
									</div>

									<?php if ( the_content() ): ?>
										<div>

											<?php the_content(); ?>
											
										</div>
									<?php endif; ?>
								</div>
							<?php endforeach;
						wp_reset_postdata(); ?>
					<?php endif;
				endwhile; ?>
			</div>
		</div>
	</main>

<?php get_footer(); ?>
