<?php global $thegravity_themeoptions; ?>

<!DOCTYPE html>
<?php
    $layoutclass = $thegravity_themeoptions['layout'];
    if (THEGRAVITY_DEV) {
        if (isset($_COOKIE['pageslayout'])) {
            $layoutclass = $_COOKIE['pageslayout'];
        }
    }
?>
<html <?php language_attributes(); ?> class="<?php echo esc_attr($layoutclass); ?>">
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">  
    <meta name="author" content="">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />    
    <title>
        <?php wp_title('|', true, 'right'); ?>
        <?php bloginfo('name'); ?>
    </title>    
    <?php if (isset($thegravity_themeoptions['favicon']) && $thegravity_themeoptions['favicon']) : ?>
        <!-- Fav and touch icons -->
        <link rel="shortcut icon" href="<?php echo $thegravity_themeoptions['favicon']; ?>">
    <?php endif; ?>
    <?php if ($thegravity_themeoptions['customcss']) : ?>
        <style type="text/css">
            <?php echo $thegravity_themeoptions['customcss']; ?>
        </style>    
    <?php endif; ?>
    <!-- Le styles -->
    <?php wp_head(); ?>    
</head>
<?php 
    $bodyclass = array();
    if (thegravity_woocommerce_exists() && is_woocommerce()) {
        $cols = thegravity_woocommerce_shop_columns();
        if ($cols == 2 || $cols == 3) {
            $bodyclass[] = 'gravity-col-woo-'.$cols;
        }
    }    
?>
<body <?php body_class($bodyclass); ?>>
    <div id="page" class="site">
        <?php $pagetitle = thegravity_metabox_values('metabox_pagetitle'); ?>
        <?php
            $headerclasses[] = $pagetitle['background'] ? 'site-header-style-2' : 'site-header-style-1';
            $headerclasses[] = $pagetitle['navigationoverwrite'] ? $pagetitle['navigationmenu'] : $thegravity_themeoptions['navigation']['menu'];
            $headerclasses[] = $pagetitle['navigationoverwrite'] ? $pagetitle['navigationsubmenu'] : $thegravity_themeoptions['navigation']['submenu'];
            if ($pagetitle['fullheight']) {
                $headerclasses[] = 'site-header-fullheight';
            }            
        ?>
        <header id="masthead" class="site-header <?php echo join(' ', $headerclasses); ?>" role="banner">                
            <div class="header-background-wrapper">
                <div class="header-background" <?php echo $pagetitle['headerparallax'] ? 'data-stellar-ratio="'.$pagetitle['headerparallaxratio'].'"' : ''; ?>>
                    <?php if ($pagetitle['background'] == 3): ?>
                        <?php echo thegravity_globals_content($pagetitle['backgroundhtml'], array('fixvideo' => true)); ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php if ($thegravity_themeoptions['headeroptional'] || THEGRAVITY_DEV): ?>
                <?php
                    $hideoptionalheader = !$thegravity_themeoptions['headeroptional'];
                    if (THEGRAVITY_DEV) {
                        if (isset($_COOKIE['headeroptional'])) {
                            $hideoptionalheader = !$_COOKIE['headeroptional'];
                        }
                    }                
                ?>
                <div class="header-secodary" <?php echo $hideoptionalheader ? 'style="display:none;"' : ''; ?>>
                    <div class="container">
                        <?php if ($thegravity_themeoptions['headeroptionaltext']): ?>
                            <div class="info">
                                <?php echo do_shortcode($thegravity_themeoptions['headeroptionaltext']); ?>
                            </div>
                        <?php endif; ?>
						<?php /**
                        <?php if (count($thegravity_themeoptions['headeroptionalsocial']['icons'])): ?>
                            <ul class="social">
                                <?php for ($i = 0; $i < count($thegravity_themeoptions['headeroptionalsocial']['icons']); $i++): ?>
                                    <li><a target="_blank" class="<?php echo $thegravity_themeoptions['headeroptionalsocial']['icons'][$i]; ?>" href="<?php echo $thegravity_themeoptions['headeroptionalsocial']['urls'][$i]; ?>"></a></li>
                                <?php endfor; ?>
                            </ul>
                        <?php endif; ?>
						**/ ?>
                    </div>
                </div>        
            <?php endif; ?>
            <?php if ($thegravity_themeoptions['headersticky']): ?>
                <div class="header-main-wrapper">
            <?php endif; ?>
            <div class="header-main header-main-style-1">
                <div class="container">
                    <?php thegravity_interface_logo(); ?>
                    <nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
                        <button class="menu-toggle"><?php _e('Main Menu', 'Rework'); ?></button>
                        <a class="screen-reader-text skip-link" href="#content"><?php _e('Skip to content', 'Rework'); ?></a>
                        <?php wp_nav_menu( array( 'theme_location' => 'Top Menu', 'menu_class' => 'nav-menu', 'fallback_cb' => false, 'walker' => new TheGravity_TopMenu_Walker_Nav_Menu() ) ); ?>
                    </nav>                        
                </div>
            </div><!-- .header-main -->       
            <?php if ($thegravity_themeoptions['headersticky']): ?>
                </div>
            <?php endif; ?>                 
            <div id="page-title">
                <div class="container">
                    <?php if ($pagetitle['subtitle']): ?>
                        <h2><?php echo do_shortcode($pagetitle['subtitle']); ?></h2>
                    <?php endif; ?>                
                    <?php if ($pagetitle['pagetitle']): ?>
                        <?php echo do_shortcode($pagetitle['pagetitle']); ?>
                    <?php elseif (get_post_type() == 'portfolio'): ?>
                        <header>
                            <h1 class="title"><?php the_title(); ?></h1>
                        </header>                          
                    <?php endif; ?>
                </div>
            </div><!-- #page-title -->                   
        </header>
        <div id="main">
            <?php 
                $common = thegravity_metabox_values('metabox_common');
                switch ($common['sidebar']['type']) {
                    // No sidebars
                    default:
                    case 0: {
                    ?>
                        <div id="primary" role="main">                                
                            <div class="container">   
                    <?php
                        break;
                    }                                
                    // Left sidebar
                    case 1: {
                    ?>                            
                        <div class="container">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="row">
                                        <div class="col-md-11">
                                            <?php get_sidebar('left'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div id="primary" role="main">
                    <?php                            
                        break;
                    }
                    // Right sidebar
                    case 2: {
                    ?>                            
                        <div class="container">
                            <div class="row">
                                <div class="col-md-8">
                                    <div id="primary" role="main">
                    <?php                            
                        break;
                    }
                    // Both sidebars
                    case 3: {
                    ?>                            
                        <div class="container">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="row">
                                        <div class="col-md-11">
                                            <?php get_sidebar('left'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div id="primary" role="main">
                    <?php                            
                        break;
                    }                                                                
                }
            ?>