<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package 	CIMGE_1.0.5
 * @since 		1.0.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-57x57.png">
<link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-60x60.png">
<link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-72x72.png">
<link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-76x76.png">
<link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-114x114.png">
<link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-144x144.png">
<link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-152x152.png">
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri(); ?>/img/apple-touch-icon-180x180.png">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon-32x32.png" sizes="32x32">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon-194x194.png" sizes="194x194">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon-96x96.png" sizes="96x96">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri(); ?>/img/android-chrome-192x192.png" sizes="192x192">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon-16x16.png" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri(); ?>/img/manifest.json">
<link rel="mask-icon" href="<?php echo get_stylesheet_directory_uri(); ?>/img/safari-pinned-tab.svg" color="#5bbad5">
<link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon.ico">
<meta name="msapplication-TileColor" content="#677db6">
<meta name="msapplication-TileImage" content="<?php echo get_stylesheet_directory_uri(); ?>/img/mstile-144x144.png">
<meta name="msapplication-config" content="<?php echo get_stylesheet_directory_uri(); ?>/img/browserconfig.xml">
<meta name="theme-color" content="#ffffff">
<?php wp_head(); ?>
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
	<div id="page">
		<div id="top">
			<div class="switch-lang">
				<ul>
					<?php
					/* @see https://polylang.wordpress.com/documentation/documentation-for-developers/functions-reference/ */
					pll_the_languages( array( 'display_names_as' => 'name', 'hide_if_no_translation'  => 1 ) );
					?>
				</ul>
			</div>
		</div>

		<header id="header" class="clearfix" role="banner">			
			<?php if ( is_front_page() || is_home() ) : ?>
				<h1 class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/cimg_logo.jpg'; ?>" width="340" height="223" alt="<?php bloginfo( 'name' ); ?> : <?php bloginfo( 'description' ); ?>" /></a></h1>
			<?php else : ?>
				<p class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/cimg_logo.jpg'; ?>" width="340" height="223" alt="<?php bloginfo( 'name' ); ?> : <?php bloginfo( 'description' ); ?>" /></a></p>
			<?php endif; ?>

			<a href="#nav"><span><?php printf( esc_html__( 'Menu', 'cdiwpchild' ) ); ?></span></a>

			<nav id="nav" role="navigation">
				<?php
					wp_nav_menu( array(
						'theme_location' => 'primary',
						'container' => false, // On ne crée pas de conteneur autour du menu
						'menu_class' => 'sf-menu', // On ajoute la class pour le menu superfish
						'menu_id' => 'primary-menu'
					) );
				?>
			</nav><!-- #site-navigation -->
		</header><!-- #masthead -->

		<div id="content">
