<?php
/**
 * Fonctions du thème
 *
 * @author 		Luc Poupard
 *
 * @link 		https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package 	CIMGE_1.0.0
 * @since 		1.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
  == Fonctions WordPress
    -- Traductions
    -- Menus de navigation
    -- Images à la Une
    -- Flux RSS
  == Styles et scripts
    -- Thème CIMV
    -- Carrousel
    -- Contact Form 7
  == Fonctions externalisées
    -- Administration
*/


/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
  /* -- @subsection Traductions -------------------- */
  /**
   * Préparer le thème pour traduction.
   * Les traductions sont placées dans le répertoire /languages/
   * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdi-base-child' )
   */
	load_child_theme_textdomain( 'cdiwpchild', get_stylesheet_directory() . '/languages' );


  /* -- @subsection Menus de navigation -------------------- */
  /**
   * Déclaration du menu de navigation principal.
   */
  // register_nav_menus( array(
  //  'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
  // ) );


  /* -- @subsection Images à la Une -------------------- */
  /**
   * On supprime le support des Images à la Une par défaut
   * Pour conserver le support, commenter la ligne suivante.
   */
  // remove_theme_support( 'post-thumbnails' );

  /* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
  // set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


  /* -- @subsection Flux RSS -------------------- */
  /**
   * On supprime le support les adresses de flux dans <head>
   * Pour conserver le support, commenter la ligne suivante.
   */
  remove_theme_support( 'automatic-feed-links' ); 
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Styles et scripts ==================== */
/* -- @subsection Thème CIMV -------------------- */
function cdiwpchild_styles() {
	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		null,
		'all'
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/* -- @section Carrousel -------------------- */
function carrousel() {
  wp_enqueue_script(
    'carrousel',
   get_stylesheet_directory_uri() . '/js/jquery-accessible-carrousel-aria.min.js',
    array( 'jquery' ), // Dépendant de jQuery
    null, // Version
    true // true = script dans le footer
  );
}
add_action( 'wp_enqueue_scripts', 'carrousel' );


/* -- @subsection Contact Form 7 -------------------- */
/**
 * @note Les CSS et JS de Contact Form 7 sont insérés sur toutes les pages par défaut. Cette fonction permet de l'afficher uniquement sur les pages où il y a un formulaire.
 * @see http://dannyvankooten.com/3935/only-load-contact-form-7-scripts-when-needed/
 */
function cdiwpchild_dequeue_contact() {
  if( is_page( array( 15, 17 ) ) ) {
    // La page de contact porte l'ID 15 donc on veut garder les styles et scripts Contact Form 7
    // La page de demande d'examen porte l'ID 17 donc on veut garder les styles et scripts Contact Form 7
  } else {
    // Dans tous les autres cas, on ne veut pas appeler les styles et scripts du plugin
    wp_dequeue_script( 'contact-form-7' );
    wp_dequeue_style( 'contact-form-7' );
  } 
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_dequeue_contact' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
  /* Notification de mises à jour du thème */
  require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

  /* Ajouter des droits à des utilisateurs */
  // require get_stylesheet_directory() . '/functions/admin_capabilities.php';

  /* Cacher des items du menu aux non administrateurs */
  require get_stylesheet_directory() . '/functions/admin_menu.php';

  /* Cacher les widgets du dashboard */
  // require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}