# CIMGE

Thème enfant de base pour les sites WordPress CDI.

* Version: 2.1.0
* License: [GPLv2 or later](http://www.gnu.org/licenses/gpl-2.0.html)

## Comment utiliser le thème ?

Ce thème est conçu pour être utilisé comme thème enfant du thème de base CDI.

Pour ajouter des modules ou composants, une flotte d'extensions est utilisable pour étendre les fonctionnalités du site.
Plus d'informations sont disponibles dans les fichiers README des extensions CDI.

### Installation

Pour l'installer, il suffit de copier/coller le thème dans le répertoire `wp-content/themes` du site WordPress.

Une fois le thème ajouté, il reste à le personnaliser pour le projet. Cela consiste à renommer ou modifier les fichiers/dossiers suivants :

* **style.css** : modifier les informations suivantes
  * *Theme Name* : donner le nom du site
  * *Description* : personnaliser la description en fonction du site
  * *Version* : comme c'est une création de thème, renseigner la valeur `1.0.0`
* **admin_update-notifier.php** dans le dossier **functions**
  * Remplacer `cdi-base-child` par le nom du site dans l'URL du fichier .json : `http://wp.cdi.ch/themes/cdi-base-child/update.json`
* **screenshot.png**
  * Modifier l'image avec le logo du site/client.
  * Un fichier PSD est disponible dans le thème local !

Une fois ces modifications appliquées, le thème peut être activé (dans l'administration) et personnalisé.

### Personnalisation

Le thème contient tous les répertoires utiles pour personnaliser le thème :

1. **css** pour les feuilles de styles.
2. **font** pour les fichiers de polices personnalisées s'il y en a.
3. **functions** pour les fonctions du thème
4. **img** pour les images utilisées dans le thème (logos, favicons…) s'il y en a.
5. **js** pour les les fichiers JavaScript utiles au thème s'il y en a.
6. **languages** pour les fichiers de traduction

#### 1. CSS

Il n'y a rien à toucher concernant les styles. Tout se passe dans le thème local.
Toutes les informations concernant l'édition des styles sont disponibles dans le README du thème local.

Pour ajouter une feuille de style dans `<head>`, compléter la combinaison de fonctions `wp_register_style()`/`wp_enqueue_style()` qui se trouvent dans la fonction `cdiwpchild_styles()` dans **functions.php**

Le code de base est celui-ci :
```
function cdiwpchild_styles() {
    wp_register_style(
        'all',
        get_stylesheet_directory_uri().'/css/styles.css',
        false,
        null,
        'all'
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );
```

Pour ajouter une feuille de style `admin.css` par exemple, ajouter un couple `wp_register_style()`/`wp_enqueue_style()`:

```
function cdiwpchild_styles() {
    wp_register_style(
        'all',
        get_stylesheet_directory_uri().'/css/styles.css',
        false,
        null,
        'all'
    );

    wp_register_style(
        'admin',
        get_stylesheet_directory_uri().'/css/admin.css',
        false,
        null,
        'admin'
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );
    wp_enqueue_style( 'admin' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );
```

#### 2. Fonts

Placer ici les fichiers de fonts personnalisées s'il y en a.
L'appel à ces fichiers se fait depuis le CSS. Voir le README du thème local pour plus d'informations à ce sujet.

#### 3. Fonctions

Le fichier **functions.php** contient les fonctions de base du thème qui sont personnalisables en fonction des besoins.

En fin du fichier, on trouve aussi les appels à des fonctions incluses dans des fichiers partiels présents dans le dossier `functions` :

```
/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
    /* Notification de mises à jour du thème */
    require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

    /* Cacher des items du menu aux non administrateurs */
    require get_stylesheet_directory() . '/functions/admin_menu.php';

    /* Cacher les widgets du dashboard */
    require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}
```
Il existe trois types de fichiers partiels :
* **Global** concerne des fonctions appliquées sur tout le site, qu'il s'agisse des pages publiques ou de l'administration.
* **Front** concerne uniquement des fonctions appliquées aux pages publiques du site.
* **Administration** concerne uniquement des fonctions appliquées aux pages de l'administration.

On retrouve cette catégorisation dans le fichier **functions.php** (code ci-dessus) ainsi que dans l'organisation des fichiers dans le dossier **functions** (chaque fichier est nommé avec le préfixe correspondant à la catégorie dans laquelle il se trouve : `global_`, `front_` ou `admin_`).

##### Personnaliser une fonction existante

Pour personnaliser ces fonctions, il suffit de décommenter la ligne lui correspondant dans le fichier **functions.php** et de personnaliser le code dans le fichier partiel.

##### Ajouter une nouvelle fonction

Pour ajouter une nouvelle fonction, il suffit de créer un nouveau fichier **.php** sur la base de ceux déjà présents dans le dossier **functions** en veillant à utiliser le préfixe correspondant à la fonction (`global_`, `front_` ou `admin_`) et en l'appelant depuis le fichier **functions.php** comme suit :

```
/* Commentaire pour dire à quoi sert le fichier */
require get_stylesheet_directory() . '/functions/admin_nom-fichier.php';
```

#### 4. Images

Placer ici les images utilisées dans le thème, tels que les logos ou les favicons.

Pour afficher les images dans les templates, utiliser la fonction `get_stylesheet_directory_uri()` qui récupère automatiquement l'URL complète du thème. Exemple :
```
<img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.png'; ?>" width="200" height="120" alt="<?php bloginfo( 'name' ); ?>" />
```

#### 5. JavaScript

Placer ici les fichiers JavaScript utiles au thème s'il y en a.

Pour ajouter l'appel d'un fichier JavaScript dans les pages, utiliser la combinaison de fonctions `wp_register_script()`/`wp_enqueue_script()` qui se trouvent dans la fonction `cdiwpchild_styles()` dans **functions.php**

Le code de base est celui-ci :
```
function cdiwpchild_styles() {
    wp_register_style(
        'all',
        get_stylesheet_directory_uri().'/css/styles.css',
        false,
        null,
        'all'
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );
```
Pour ajouter un script `carrousel.js` par exemple, ajouter un couple `wp_register_script()`/`wp_enqueue_script()`:

```
function cdiwpchild_styles() {
    wp_register_style(
        'all',
        get_stylesheet_directory_uri().'/css/styles.css',
        false,
        null,
        'all'
    );

    wp_register_script(
        'carrousel',
        get_stylesheet_directory_uri() . '/js/carrousel.js',
        false,
        null,
        true
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );
    wp_enqueue_script( 'carrousel' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );
```

#### 6. Traductions

Le répertoire `languages` contient les fichiers de traduction du thème.
En cas d'ajout de nouveaux termes dans le thème, il faut mettre à jour ces fichiers avec les traductions dans chacune des langues disponibles.

Pour en savoir plus sur la traduction de thèmes WordPress, voici quelques ressources utiles (en anglais) :
* [Translate WordPress](https://make.wordpress.org/polyglots/teams/)
* [Themes Localization](https://developer.wordpress.org/themes/functionality/localization/)
* [load_theme_textdomain()](https://developer.wordpress.org/reference/functions/load_theme_textdomain/)

## Changelog

L'historique détaillé des modifications est disponible dans le [changelog](http://wp.cdi.ch/themes/cdi-base-child/).

En cas de mise à jour du thème, le fichier `CHANGELOG.md` à mettre à jour se trouve dans le répertoire `depot` du thème de base sur TFS.

La syntaxe du fichier Changelog est la suivante :

```
## 1.0.0 *AAAA-MM-DD*

* **Ajouté :** Nouvelle fonction
* **Modifié :** Changement apporté sur une fonction existante
* **Déprécié :** Fonction dépréciée (généralement supprimée dans une version ultérieure)
* **Supprimé :** Fonction supprimée
* **Corrigé :** Bug fixé
* **Sécurité :** Répare une vulnérabilité, implique en général de faire une mise à jour
```

Pour en savoir plus sur la lecture (et l'édition) d'un changelog, voici deux ressources utiles (en anglais) :
* [Semantic Versioning 2.0.0](http://semver.org/)
* [Keep a Changelog](http://keepachangelog.com/)
