<?php
/*
Template Name: Liste des prestations
*/
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	CIMF_1.0.0
 * @since 		1.0.0
 */

get_header(); ?>

	<main id="main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<header class="entry-header">
					<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

					<?php if ( function_exists('ffeeeedd__ariane') && !is_front_page() ) {
						ffeeeedd__ariane();
					} ?>
				</header>

				<div class="entry-content clearfix">

					<?php
					$args = array(
						'post_type'			=> 'page',
						'posts_per_page'	=> -1,
						'post_parent'		=> $post->ID,
						'order'				=> 'ASC',
						'orderby'			=> 'menu_order'
					 );

					$parent = new WP_Query( $args );

					if ( $parent->have_posts() ) : ?>

						<?php while ( $parent->have_posts() ) : $parent->the_post(); ?>

							<div id="parent-<?php the_ID(); ?>" class="prestation-item">

								<a href="<?php the_permalink(); ?>">

									<div class="prestation-thumbnail">
										<?php the_post_thumbnail(); ?>
									</div>

									<h2><?php the_title(); ?></h2>

								</a>

							</div>

						<?php endwhile; ?>

					<?php endif; wp_reset_query(); ?>
						<!--  -->
				</div>
			</article>

		<?php endwhile; // End of the loop. ?>

	</main>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
