<?php
/*
Template Name: Prestation
*/
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	CIMF_1.0.0
 * @since 		1.0.0
 */

get_header(); ?>

	<main id="main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<header class="entry-header">
					<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

					<?php if ( function_exists('ffeeeedd__ariane') && !is_front_page() ) {
						ffeeeedd__ariane();
					} ?>
				</header>

				<div class="entry-content clearfix">

					<div class="prestation-content">
						<?php the_content(); ?>
					</div>

					<div class="prestation-illustration">
						<?php
						$prestation_illustration = esc_html( get_post_meta( get_the_ID(), 'prestation_illustration', true ) );
						$prestation_illustration = wp_get_attachment_image( $prestation_illustration, 'full' );
						?>

						<?php echo $prestation_illustration ?>							
					</div>
					
				</div>
			</article>

		<?php endwhile; // End of the loop. ?>

	</main>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
