<?php
/*
Template Name: Équipe
*/
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	CIMF_1.0.0
 * @since 		1.0.0
 */

get_header(); ?>

	<main id="main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<header class="entry-header">
					<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

					<?php if ( function_exists('ffeeeedd__ariane') && !is_front_page() ) {
						ffeeeedd__ariane();
					} ?>
				</header>

				<div class="entry-content clearfix">

					<?php if( have_rows('radiologues') ): ?>

						<h2><?php printf( esc_html__( 'Nos radiologues', 'cdiwpchild' ) ); ?></h2>

						<div class="radiologue-list clearfix">

							<?php while( have_rows('radiologues') ): the_row(); 
							// vars
							$radiologue_photo = get_sub_field('radiologue_photo');
							$radiologue_nom = get_sub_field('radiologue_nom');
							?>

								<div class="radiologue-item">
									<div class="radiologue-thumbnail">
										<img src="<?php echo $radiologue_photo['url']; ?>" alt="" />
									</div>

									<div class="radiologue-nom">
									    <?php echo $radiologue_nom; ?>
									</div>
								</div>

							<?php endwhile; ?>

						</div>

					<?php endif; ?>


					<?php if( have_rows('equipe') ): ?>

						<h2><?php printf( esc_html__( 'Notre équipe', 'cdiwpchild' ) ); ?></h2>

						<div class="equipe-list clearfix">

							<?php while( have_rows('equipe') ): the_row(); 
							// vars
							$equipe_photo = get_sub_field('equipe_photo');
							$equipe_nom = get_sub_field('equipe_nom');
							?>

								<div class="equipe-item">
									<div class="equipe-thumbnail">
										<img src="<?php echo $equipe_photo['url']; ?>" alt="" />
									</div>

									<div class="equipe-nom">
									    <?php echo $equipe_nom; ?>
									</div>
								</div>

							<?php endwhile; ?>

						</div>

					<?php endif; ?>

				</div>
			</article>

		<?php endwhile; // End of the loop. ?>

	</main>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
