<?php
/**
 * Fonction pour cacher des items de la barre d'admin
 *
 * @author 	Luc Poupard
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Suppression des liens natifs
		-- WordPress
		-- Site
		-- Commentaires
		-- Mises à jour
		-- Créer
		-- Extensions
		-- Salutations
	== Lien Personnaliser
	== Ajout de liens personnalisés
		-- Ajout d'un menu avec sous-menus
		-- Styles pour le menu
 */


/* == @section Suppression des liens natifs ==================== */
/**
 * Pour chaque entrée du menu, on peut supprimer le menu complet ou choisir juste certains sous-menus.
 * Si on masque le menu, il n'y a pas besoin de décommenter les sous-menu.
 */
function cdiwp_admin_bar() {
	global $wp_admin_bar;

	/* -- @subsection WordPress -------------------- */
	/**
	 * Menu complet
	 * Pour cacher uniquement certains sous-menu,
	 * commenter cette ligne et décommenter les menus à masquer.
	 */
	$wp_admin_bar->remove_menu( 'wp-logo' );

	/* About WordPress */
	// $wp_admin_bar->remove_menu( 'about' );

	/* WordPress.org */
	// $wp_admin_bar->remove_menu( 'wporg' );

	/* Documentation */
	// $wp_admin_bar->remove_menu( 'documentation' );

	/* Support Forums */
	// $wp_admin_bar->remove_menu( 'support-forums' );

	/* Feedback */
	// $wp_admin_bar->remove_menu( 'feedback' );


	/* -- @subsection Site -------------------- */
	/**
	 * Menu complet
	 * Pour cacher uniquement certains sous-menu,
	 * commenter cette ligne et décommenter les menus à masquer.
	 */
	// $wp_admin_bar->remove_menu( 'site-name' );

	/* Visit Site */
	$wp_admin_bar->remove_menu( 'view-site' );

	/* Dashboard */
	$wp_admin_bar->remove_menu( 'dashboard' );

	/* Themes */
	$wp_admin_bar->remove_menu( 'themes' );

	/* Widgets */
	$wp_admin_bar->remove_menu( 'widgets' );

	/* Menus */
	$wp_admin_bar->remove_menu( 'menus' );


	/* -- @subsection Commentaires -------------------- */
	$wp_admin_bar->remove_menu( 'comments' );


	/* -- @subsection Mises à jour -------------------- */
	$wp_admin_bar->remove_menu( 'updates' );


	/* -- @subsection Créer -------------------- */
	/**
	 * Menu complet
	 * Pour cacher uniquement certains sous-menu,
	 * commenter cette ligne et décommenter les menus à masquer.
	 */
	$wp_admin_bar->remove_menu( 'new-content' );

	/* Post */
	// $wp_admin_bar->remove_menu( 'new-post' );

	/* Media */
	// $wp_admin_bar->remove_menu( 'new-media' );

	/* Link */
	// $wp_admin_bar->remove_menu( 'new-link' );

	/* Page */
	// $wp_admin_bar->remove_menu( 'new-page' );

	/* User */
	// $wp_admin_bar->remove_menu( 'new-user' );


    /* -- @subsection Extensions -------------------- */
    /* Enfold */
    // $wp_admin_bar->remove_menu( 'avia' );


	/* -- @subsection Salutations -------------------- */
	/**
	 * Menu complet
	 * Pour cacher uniquement certains sous-menu,
	 * commenter cette ligne et décommenter les menus à masquer.
	 */
	// $wp_admin_bar->remove_menu( 'my-account' );

	/* Sous-menu seulement */
	// $wp_admin_bar->remove_menu( 'user-actions' );

	/* Username */
	// $wp_admin_bar->remove_menu( 'user-info' );

	/* Edit my profile */
	// $wp_admin_bar->remove_menu( 'edit-profile' );

	/* Log Out */
	// $wp_admin_bar->remove_menu( 'logout' );
}
add_action( 'wp_before_admin_bar_render', 'cdiwp_admin_bar' );


/* == @section Lien Personnaliser ==================== */
function cdiwp_admin_bar_customize( $wp_admin_bar ) {
	$wp_admin_bar->remove_node( 'customize' );
}
add_action( 'admin_bar_menu', 'cdiwp_admin_bar_customize', 999 );


/* == @section Ajout de liens personnalisés ==================== */

/* -- @subsection Ajout d'un menu avec sous-menus -------------------- */
// function cdiwp_admin_bar_custom( $wp_admin_bar ) {
// 	$menu = array(
// 		'id' => 'menu-custom',
// 		'title' => '<span class="wp-admin-menu-custom"></span> Menu', // Le span permet d'afficher un dashicon à l'aide du css perosnnalisé
// 		'href' => false
// 	);

// 	$sousmenu1 = array(
// 		'id' => 'menu-custom-1',
// 		'parent' => 'menu-custom', // id du menu parent
// 		'title' => 'Sous-menu 1', // intitulé de l'item
// 		'href' => 'http://www.google.fr',
// 		'meta' => array(
// 			'class' => 'menu-custom-1',
// 			'target' => '_blank'
// 		)
// 	);

// 	$sousmenu2 = array(
// 		'id' => 'menu-custom-2',
// 		'parent' => 'menu-custom', // id du menu parent
// 		'title' => 'Sous-menu 2', // intitulé de l'item
// 		'href' => 'http://www.google.ch',
// 		'meta' => array(
// 			'class' => 'menu-custom-2',
// 			'target' => '_blank'
// 		)
// 	);

// 	$wp_admin_bar->add_node( $menu );
// 	$wp_admin_bar->add_node( $sousmenu1 );
// 	$wp_admin_bar->add_node( $sousmenu2 );
// }
// add_action( 'admin_bar_menu', 'cdiwp_admin_bar_custom', 999 );


/* -- @subsection Styles pour le menu -------------------- */
/**
 * Ce code appelle une feuille de style admin.css qui doit être présente
 * dans le dossier 'styles' du thème
 */
// function cdiwp_admin_bar_custom_css() {
// 	/* On teste si l'utiisateur a les droits suffisants (ici admin) */
// 	if( current_user_can( 'add_users' ) ) {
// 		wp_register_style(
// 			'cdiwp_admin_bar_custom_css',
// 			esc_url( get_template_directory_uri() ) . '/styles/admin.css',
// 			'',
// 			'',
// 			'screen' 
// 		);
// 		wp_enqueue_style( 'add_custom_wp_toolbar_css' );
// 	}
// }
// add_action( 'admin_enqueue_scripts', 'cdiwp_admin_bar_custom_css' ); // On charge le style dans l'admin
// add_action( 'wp_enqueue_scripts', 'cdiwp_admin_bar_custom_css' ); // On charge le style sur le front aussi