<?php
/**
 * Notification de mises à jour du thème
 *
 * @author	Luc Poupard
 *
 * Basé sur le code de Xpark Media :
 * @link	https://xparkmedia.com/blog/add-update-notification-selfhosted-premium-themes-plugins/
 * Mais on utilise wp_remote_get() au lieu de curl_init() :
 * @link	https://pippinsplugins.com/using-wp_remote_get-to-parse-json-from-remote-apis/
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


function cimf_update_notifier ( $transient ) {
	if( empty( $transient->checked['cimf'] ) )
	return $transient;

	$response = wp_remote_get( 'http://wp.cdi.ch/themes/cimf/update.json' );

	if( is_wp_error( $response ) ) {
		return false;
	}

	$result = wp_remote_retrieve_body( $response );
	$data = json_decode( $result );

	/* On vérifie la version sur le serveur par rapport à la version installée */
	if( ! empty( $data ) ) {
		if( version_compare( $transient->checked['cimf'], $data->new_version, '<' ) )
		$transient->response['cimf'] = (array) $data;
	}

	return $transient;
} 
add_filter ( 'pre_set_site_transient_update_themes', 'cimf_update_notifier' );