<?php
/*
Template Name: Accueil
*/
/**
 * The template for displaying the front page.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package 	CIMF_1.0.0
 * @since 		1.0.0
 */


get_header(); ?>
		
	<main id="main" class="site-main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<div class="carrousel">
				<div class="carrousel__container"
				data-carrousel-btn-previous-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-previous.png' ?>" 
				data-carrousel-btn-next-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-next.png' ?>"
				data-carrousel-btn-previous-text="Précédent"
				data-carrousel-btn-next-text="Suivant"
				data-carrousel-prefix-classes="news"
				data-carrousel-transition="slide"
				data-carrousel-existing-hx="h2">

				<?php if( have_rows('accueil_carrousel') ): ?>

					<?php while( have_rows('accueil_carrousel') ): the_row(); 
					// vars
					$carrousel_item = get_sub_field('carrousel_image');
					?><!--
					--><div class="carrousel__content"><img src="<?php echo $carrousel_item['url']; ?>" alt="" /></div><!--
					--><?php endwhile; ?>

				<?php endif; ?>

				</div>
			</div>

			<div id="post-<?php the_ID(); ?>" class="home-content clearfix">
				<div class="home-bienvenue">
					<?php
					/*
					 * On récupère les données des champs ACF
					 * @note Utilisation de la fonction native get_post_meta plutôt que du the_field d'ACF
					 * @link https://www.gregoirenoyelle.com/wordpress-reduire-dependances-avanced-custom-fields/
					 *
					 * Ex ACF : <?php the_field( 'accueil_titre' ); ?>
					 *
					 * @note Shortcode
					 * @link http://www.billerickson.net/advanced-custom-fields-frontend-dependency/#comment-255652
					 */
					$accueil_titre = esc_html( get_post_meta( get_the_ID(), 'accueil_titre', true ) );
					
					/*
					 * @note Pour les champs contenant du formatage HTML
					 * @link https://www.gregoirenoyelle.com/wordpress-reduire-dependances-avanced-custom-fields/#comment-39475
					 */
					$accueil_texte = apply_filters( 'the_content', get_post_meta( get_the_ID(), 'accueil_texte', true ) );
					?>

					<h2><?php echo $accueil_titre ?></h2>
					<div><?php echo $accueil_texte ?></div>
				</div>

				<div class="home-equipe">
					<?php						
					/*
					 * @note On récupère l'ID puis ensuite le permalien
					 */
					$equipe_lien = esc_html( get_post_meta( get_the_ID(), 'bloc_equipe_lien', true ) );
					$equipe_lien = esc_url( get_permalink( $equipe_lien ) );

					$equipe_texte = esc_html( get_post_meta( get_the_ID(), 'bloc_equipe_title_lien', true ) );

					$equipe_image = esc_html( get_post_meta( get_the_ID(), 'bloc_equipe_image', true ) );
					$equipe_image = wp_get_attachment_image( $equipe_image, 'full' );
					?>

					<?php echo $equipe_image ?>

					<a href="<?php echo $equipe_lien ?>" class="button"><?php echo $equipe_texte ?></a>
				</div>

				<div class="home-prestations">
					<?php						
					/*
					 * @note On récupère l'ID puis ensuite le permalien
					 */
					$prestation_lien = esc_html( get_post_meta( get_the_ID(), 'bloc_prestation_lien', true ) );
					$prestation_lien = esc_url( get_permalink( $prestation_lien ) );

					$prestation_texte = esc_html( get_post_meta( get_the_ID(), 'bloc_prestation_title_lien', true ) );

					$prestation_image = esc_html( get_post_meta( get_the_ID(), 'bloc_prestation_image', true ) );
					$prestation_image = wp_get_attachment_image( $prestation_image, 'full' );
					?>
					
					<?php echo $prestation_image ?>

					<a href="<?php echo $prestation_lien ?>" class="button"><?php echo $prestation_texte ?></a>
				</div>
			</div>

		<?php endwhile; // End of the loop. ?>

	</main>

<?php get_footer(); ?>
