<?php
/**
 * Fonction pour créer un widget Facebook
 *
 * @author	Luc Poupard
 * @see		http://www.guillaumevoisin.fr/tutoriels/tutoriel-wordpress-creer-un-widget
 * @note	Dans le tuto précédent, remplacer "parent::WP_Widget" par "parent::__construct"
 *			http://themes-wordpress-francais.com/notice-wp_widget-solution/
 *
 * @package	CDI_Child_Theme
 * @since	CDI_Child_Theme 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Constructeur
	== Contenu du widget à afficher
	== Modification des paramètres du widget
	== Affichage des paramètres du widget dans l'admin
 */

class NewsletterCDI extends WP_Widget {
	/* == @section Constructeur ==================== */
	function NewsletterCDI() {
		parent::__construct(
			false,
			$name = 'Inscription Newsletter',
			array(
				"description" => 'Formulaire d\'inscription à la newsletter'
			)
		);
	}

	/* == @section Contenu du widget à afficher ==================== */
	function widget( $args, $instance ) {
		/* Extraction des paramètres du widget */
		extract( $args );

		/* Récupération de chaque paramètre */
		$nl_title = apply_filters( 'widget_title', $instance['nl_title'] );
		$nl_url = $instance['nl_url'];
		$nl_name = $instance['nl_name'];
		$nl_text = $instance['nl_text'];

		/* Voir le détail sur ces variables plus bas */
		echo $before_widget;

		/* On affiche un titre si le paramètre est rempli */
    	if( $nl_title )
        echo $before_title . $nl_title . $after_title;
		?>

		<div class="textwidget">
			<a href="<?php echo $nl_url ?>" target="_blank"><?php echo $nl_name ?></a> <?php echo $nl_text ?>
		</div>

		<?php
	}

	/* == @section Modification des paramètres du widget ==================== */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Récupération des paramètres envoyés */
		$instance['nl_title'] = strip_tags( $new_instance['nl_title'] );
		$instance['nl_url'] = $new_instance['nl_url'];
		$instance['nl_name'] = $new_instance['nl_name'];
		$instance['nl_text'] = $new_instance['nl_text'];

		return $instance;
	}

	/* == @section Affichage des paramètres du widget dans l'admin ==================== */
	function form( $instance ) {
		$nl_title = esc_attr( $instance['nl_title'] );
		$nl_url = esc_attr( $instance['nl_url'] );
		$nl_name = esc_attr( $instance['nl_name'] );
		$nl_text = esc_attr( $instance['nl_text'] );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'nl_title' ); ?>">
				<?php _e( 'Titre :', 'cdiwp' ); ?>
				<input class="widefat" id="<?php echo $this->get_field_id( 'nl_title' ); ?>" name="<?php echo $this->get_field_name( 'nl_title' ); ?>" type="text" value="<?php echo $nl_title; ?>" />
			</label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'nl_url' ); ?>">
				<?php _e( 'URL de la page d\'inscription :', 'cdiwp' ); ?>
				<input class="widefat" id="<?php echo $this->get_field_id( 'nl_url' ); ?>" name="<?php echo $this->get_field_name( 'nl_url' ); ?>" type="text" value="<?php echo $nl_url; ?>" />
			</label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'nl_name' ); ?>">
				<?php _e( 'Texte du lien :', 'cdiwp' ); ?>
				<input class="widefat" id="<?php echo $this->get_field_id( 'nl_name' ); ?>" name="<?php echo $this->get_field_name( 'nl_name' ); ?>" type="text" value="<?php echo $nl_name; ?>" />
			</label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'nl_text' ); ?>">
				<?php _e( 'Texte complémentaire :', 'cdiwp' ); ?>
				<input class="widefat" id="<?php echo $this->get_field_id( 'nl_text' ); ?>" name="<?php echo $this->get_field_name( 'nl_text' ); ?>" type="text" value="<?php echo $nl_text; ?>" />
			</label>
		</p>

		<?php
	}
}
add_action( 'widgets_init', create_function( '', 'return register_widget("NewsletterCDI");' ) );