<?php
/**
 * CDI Demo Theme : fonctions du thème.
 *
 * @link	https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Demo_Theme
 * @since	CDI_Demo_Theme 1.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Fonctions WordPress
		-- Traductions
		-- Menus de navigation
		-- Images à la Une
		-- Flux RSS
	== Widgets
	== Ajout des styles du thème
	== Fonctions externalisées
		-- Global
		-- Front
		-- Administration
*/


/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
	/* -- @subsection Traductions -------------------- */
	/**
	 * Préparer le thème pour traduction.
	 * Les traductions sont placées dans le répertoire /languages/
	 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdiwp' )
	 */
	load_child_theme_textdomain( 'cdiwpchild', get_stylesheet_directory() . '/languages' );


	/* -- @subsection Menus de navigation -------------------- */
	/**
	 * Déclaration du menu de navigation principal.
	 */
	// register_nav_menus( array(
	// 	'secondary' => esc_html__( 'Secondary menu', 'cdiwpchild' ),
	// ) );


	/* -- @subsection Images à la Une -------------------- */
	/**
	 * On ajoute le support des Images à la une
	 */
	// add_theme_support( 'post-thumbnails' );
	// set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


	/* -- @subsection Flux RSS -------------------- */
	/**
	 * On ajoute les adresses de flux dans <head>
	 */
	// add_theme_support( 'automatic-feed-links' );	
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Widgets ==================== */
/**
 * @note On déclare une zone de widgets Sidebar par défaut.
 * Pour ajouter des zone de widgets supplémentaires, passer par le thème enfant.
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function cdiwpchild_widgets_init() {
	register_sidebar( array(
		'name'			=> esc_html__( 'Sidebar', 'cdiwp' ),
		'id'			=> 'sidebar-1',
		'description'	=> esc_html__( 'Add widgets here.', 'cdiwp' ),
		'before_widget'	=> '<aside id="%1$s" class="widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<div class="widget-title">',
		'after_title'	=> '</div>',
	) );
}
add_action( 'widgets_init', 'cdiwpchild_widgets_init' );


/* == @section Ajout des styles du thème ==================== */
function cdiwpchild_styles() {
	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		null,
		'all'
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';

/* Widgets */
// require get_stylesheet_directory() . '/functions/global_widget_facebook.php';
// require get_stylesheet_directory() . '/functions/global_widget_newsletter-cdi.php';

/* Shortcodes */
// require get_stylesheet_directory() . '/functions/global_shortcodes.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

	/* Ajouter des droits à des utilisateurs */
	// require get_stylesheet_directory() . '/functions/admin_capabilities.php';

	/* Cacher des items du menu aux non administrateurs */
	// require get_stylesheet_directory() . '/functions/admin_menu.php';

	/* Cacher les widgets du dashboard */
	// require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}